/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.reflect.AbstractInvocationHandler;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import org.opendaylight.jsonrpc.binding.RpcInvocationAdapter;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;

abstract class AbstractHandler<T extends RpcService>
extends AbstractInvocationHandler {
    protected final BiMap<Method, RpcDefinition> rpcMethodMap;
    protected final RpcInvocationAdapter adapter;

    AbstractHandler(Class<T> type, RpcInvocationAdapter adapter) {
        this.adapter = Objects.requireNonNull(adapter);
        this.rpcMethodMap = (BiMap)adapter.codec().getRpcMethodToSchemaPath(type).entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), adapter.schemaContext().getOperations().stream().filter(r -> r.getPath().equals(e.getValue())).findFirst().get())).collect(Collector.of(ImmutableBiMap::builder, (builder, entry) -> builder.put(entry.getKey(), entry.getValue()), (k, v) -> k.putAll((Map)v.build()), ImmutableBiMap.Builder::build, new Collector.Characteristics[0]));
    }
}

