/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EntityTypeBuilder
implements Builder<EntityType> {
    private List<Entity> _entity;
    private String _type;
    private EntityTypeKey key;
    Map<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>> augmentation = Collections.emptyMap();

    public EntityTypeBuilder() {
    }

    public EntityTypeBuilder(EntityType base) {
        Map aug;
        this.key = base.key();
        this._type = base.getType();
        this._entity = base.getEntity();
        if (base instanceof EntityTypeImpl) {
            EntityTypeImpl impl = (EntityTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>(aug);
        }
    }

    public EntityTypeKey key() {
        return this.key;
    }

    public List<Entity> getEntity() {
        return this._entity;
    }

    public String getType() {
        return this._type;
    }

    public <E$$ extends Augmentation<EntityType>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public EntityTypeBuilder withKey(EntityTypeKey key) {
        this.key = key;
        return this;
    }

    public EntityTypeBuilder setEntity(List<Entity> values) {
        this._entity = values;
        return this;
    }

    public EntityTypeBuilder setType(String value) {
        this._type = value;
        return this;
    }

    public EntityTypeBuilder addAugmentation(Class<? extends Augmentation<EntityType>> augmentationType, Augmentation<EntityType> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EntityTypeBuilder removeAugmentation(Class<? extends Augmentation<EntityType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EntityType build() {
        return new EntityTypeImpl(this);
    }

    private static final class EntityTypeImpl
    implements EntityType {
        private final List<Entity> _entity;
        private final String _type;
        private final EntityTypeKey key;
        private Map<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        EntityTypeImpl(EntityTypeBuilder base) {
            this.key = base.key() != null ? base.key() : new EntityTypeKey(base.getType());
            this._type = this.key.getType();
            this._entity = base.getEntity();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<EntityType> getImplementedInterface() {
            return EntityType.class;
        }

        @Override
        public EntityTypeKey key() {
            return this.key;
        }

        @Override
        public List<Entity> getEntity() {
            return this._entity;
        }

        @Override
        public String getType() {
            return this._type;
        }

        public <E$$ extends Augmentation<EntityType>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._entity);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EntityType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EntityType other = (EntityType)obj;
            if (!Objects.equals(this._entity, other.getEntity())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EntityTypeImpl otherImpl = (EntityTypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"EntityType");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_entity", this._entity);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_type", (Object)this._type);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

