/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.sharding.DistributedShardModification;
import org.opendaylight.controller.cluster.sharding.DistributedShardModificationCursor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardWriteTransaction;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.store.inmemory.ForeignShardThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardProxyTransaction
implements DOMDataTreeShardWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(ShardProxyTransaction.class);
    private final DOMDataTreeIdentifier shardRoot;
    private final Collection<DOMDataTreeIdentifier> prefixes;
    private final DistributedShardModification modification;
    private ClientTransaction currentTx;
    private final List<DOMStoreThreePhaseCommitCohort> cohorts = new ArrayList<DOMStoreThreePhaseCommitCohort>();
    private DOMDataTreeWriteCursor cursor = null;

    ShardProxyTransaction(DOMDataTreeIdentifier shardRoot, Collection<DOMDataTreeIdentifier> prefixes, DistributedShardModification modification) {
        this.shardRoot = (DOMDataTreeIdentifier)Preconditions.checkNotNull((Object)shardRoot);
        this.prefixes = (Collection)Preconditions.checkNotNull(prefixes);
        this.modification = (DistributedShardModification)((Object)Preconditions.checkNotNull((Object)((Object)modification)));
    }

    private DOMDataTreeWriteCursor getCursor() {
        if (this.cursor == null) {
            this.cursor = new DistributedShardModificationCursor(this.modification, this);
        }
        return this.cursor;
    }

    @Nonnull
    public DOMDataTreeWriteCursor createCursor(@Nonnull DOMDataTreeIdentifier prefix) {
        this.checkAvailable(prefix);
        YangInstanceIdentifier relativePath = this.toRelative(prefix.getRootIdentifier());
        DOMDataTreeWriteCursor ret = this.getCursor();
        ret.enter((Iterable)relativePath.getPathArguments());
        return ret;
    }

    void cursorClosed() {
        this.cursor = null;
        this.modification.cursorClosed();
    }

    private void checkAvailable(DOMDataTreeIdentifier prefix) {
        for (DOMDataTreeIdentifier p : this.prefixes) {
            if (!p.contains(prefix)) continue;
            return;
        }
        throw new IllegalArgumentException("Prefix[" + prefix + "] not available for this transaction. Available prefixes: " + this.prefixes);
    }

    private YangInstanceIdentifier toRelative(YangInstanceIdentifier path) {
        Optional relative = path.relativeTo(this.modification.getPrefix().getRootIdentifier());
        Preconditions.checkArgument((boolean)relative.isPresent());
        return (YangInstanceIdentifier)relative.get();
    }

    public void ready() {
        LOG.debug("Readying transaction for shard {}", (Object)this.shardRoot);
        Preconditions.checkNotNull((Object)((Object)this.modification), (Object)"Attempting to ready an empty transaction.");
        this.cohorts.add(this.modification.seal());
        for (Map.Entry<DOMDataTreeIdentifier, ForeignShardModificationContext> entry : this.modification.getChildShards().entrySet()) {
            this.cohorts.add((DOMStoreThreePhaseCommitCohort)new ForeignShardThreePhaseCommitCohort(entry.getKey(), entry.getValue()));
        }
    }

    public void close() {
        this.cohorts.forEach(DOMStoreThreePhaseCommitCohort::abort);
        this.cohorts.clear();
        if (this.currentTx != null) {
            this.currentTx.abort();
            this.currentTx = null;
        }
    }

    public ListenableFuture<Void> submit() {
        LOG.debug("Submitting transaction for shard {}", (Object)this.shardRoot);
        this.checkTransactionReadied();
        AsyncFunction validateFunction = input -> this.prepare();
        AsyncFunction prepareFunction = input -> this.commit();
        ListenableFuture prepareFuture = Futures.transformAsync(this.validate(), (AsyncFunction)validateFunction, (Executor)MoreExecutors.directExecutor());
        return Futures.transformAsync((ListenableFuture)prepareFuture, (AsyncFunction)prepareFunction, (Executor)MoreExecutors.directExecutor());
    }

    private void checkTransactionReadied() {
        Preconditions.checkState((!this.cohorts.isEmpty() ? 1 : 0) != 0, (Object)"Transaction not readied yet");
    }

    public ListenableFuture<Boolean> validate() {
        LOG.debug("Validating transaction for shard {}", (Object)this.shardRoot);
        this.checkTransactionReadied();
        List futures = this.cohorts.stream().map(DOMStoreThreePhaseCommitCohort::canCommit).collect(Collectors.toList());
        final SettableFuture ret = SettableFuture.create();
        Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new FutureCallback<List<Boolean>>(){

            public void onSuccess(List<Boolean> result) {
                ret.set((Object)true);
            }

            public void onFailure(Throwable throwable) {
                ret.setException(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ret;
    }

    public ListenableFuture<Void> prepare() {
        LOG.debug("Preparing transaction for shard {}", (Object)this.shardRoot);
        this.checkTransactionReadied();
        List futures = this.cohorts.stream().map(DOMStoreThreePhaseCommitCohort::preCommit).collect(Collectors.toList());
        final SettableFuture ret = SettableFuture.create();
        Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(List<Void> result) {
                ret.set(null);
            }

            public void onFailure(Throwable throwable) {
                ret.setException(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ret;
    }

    public ListenableFuture<Void> commit() {
        LOG.debug("Committing transaction for shard {}", (Object)this.shardRoot);
        this.checkTransactionReadied();
        List futures = this.cohorts.stream().map(DOMStoreThreePhaseCommitCohort::commit).collect(Collectors.toList());
        final SettableFuture ret = SettableFuture.create();
        Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(List<Void> result) {
                ret.set(null);
            }

            public void onFailure(Throwable throwable) {
                ret.setException(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ret;
    }
}

