/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import akka.pattern.AskTimeoutException;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.exceptions.LocalShardNotFoundException;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.NotInitializedException;
import org.opendaylight.controller.cluster.datastore.exceptions.PrimaryNotFoundException;
import org.opendaylight.controller.cluster.datastore.exceptions.TimeoutException;
import org.opendaylight.controller.cluster.datastore.exceptions.UnknownMessageException;
import org.opendaylight.controller.cluster.datastore.messages.FindLocalShard;
import org.opendaylight.controller.cluster.datastore.messages.FindPrimary;
import org.opendaylight.controller.cluster.datastore.messages.LocalPrimaryShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardNotFound;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.messages.RemotePrimaryShardFound;
import org.opendaylight.controller.cluster.datastore.messages.UpdateSchemaContext;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategyFactory;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;
import org.opendaylight.controller.cluster.datastore.utils.TransactionRateLimiter;
import org.opendaylight.controller.cluster.raft.client.messages.Shutdown;
import org.opendaylight.controller.cluster.reporting.MetricsReporter;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ActorContext {
    private static final Logger LOG = LoggerFactory.getLogger(ActorContext.class);
    private static final String DISTRIBUTED_DATA_STORE_METRIC_REGISTRY = "distributed-data-store";
    private static final String METRIC_RATE = "rate";
    private static final Mapper<Throwable, Throwable> FIND_PRIMARY_FAILURE_TRANSFORMER = new Mapper<Throwable, Throwable>(){

        public Throwable apply(Throwable failure) {
            Throwable actualFailure = failure;
            if (failure instanceof AskTimeoutException) {
                actualFailure = new NotInitializedException("Timed out trying to find the primary shard. Most likely cause is the shard is not initialized yet.");
            }
            return actualFailure;
        }
    };
    public static final String BOUNDED_MAILBOX = "bounded-mailbox";
    public static final String COMMIT = "commit";
    private final ActorSystem actorSystem;
    private final ActorRef shardManager;
    private final ClusterWrapper clusterWrapper;
    private final Configuration configuration;
    private DatastoreContext datastoreContext;
    private FiniteDuration operationDuration;
    private Timeout operationTimeout;
    private final String selfAddressHostPort;
    private TransactionRateLimiter txRateLimiter;
    private Timeout transactionCommitOperationTimeout;
    private Timeout shardInitializationTimeout;
    private final Dispatchers dispatchers;
    private volatile SchemaContext schemaContext;
    private volatile boolean updated;
    private final MetricRegistry metricRegistry = MetricsReporter.getInstance((String)"org.opendaylight.controller.cluster.datastore").getMetricsRegistry();
    private final PrimaryShardInfoFutureCache primaryShardInfoCache;
    private final ShardStrategyFactory shardStrategyFactory;

    public ActorContext(ActorSystem actorSystem, ActorRef shardManager, ClusterWrapper clusterWrapper, Configuration configuration) {
        this(actorSystem, shardManager, clusterWrapper, configuration, DatastoreContext.newBuilder().build(), new PrimaryShardInfoFutureCache());
    }

    public ActorContext(ActorSystem actorSystem, ActorRef shardManager, ClusterWrapper clusterWrapper, Configuration configuration, DatastoreContext datastoreContext, PrimaryShardInfoFutureCache primaryShardInfoCache) {
        this.actorSystem = actorSystem;
        this.shardManager = shardManager;
        this.clusterWrapper = clusterWrapper;
        this.configuration = configuration;
        this.datastoreContext = datastoreContext;
        this.dispatchers = new Dispatchers(actorSystem.dispatchers());
        this.primaryShardInfoCache = primaryShardInfoCache;
        LogicalDatastoreType convertedType = LogicalDatastoreType.valueOf((String)datastoreContext.getLogicalStoreType().name());
        this.shardStrategyFactory = new ShardStrategyFactory(configuration, convertedType);
        this.setCachedProperties();
        Address selfAddress = clusterWrapper.getSelfAddress();
        this.selfAddressHostPort = selfAddress != null && !selfAddress.host().isEmpty() ? (String)selfAddress.host().get() + ":" + selfAddress.port().get() : null;
    }

    private void setCachedProperties() {
        this.txRateLimiter = new TransactionRateLimiter(this);
        this.operationDuration = FiniteDuration.create((long)this.datastoreContext.getOperationTimeoutInMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.operationTimeout = new Timeout(this.operationDuration);
        this.transactionCommitOperationTimeout = new Timeout(FiniteDuration.create((long)this.datastoreContext.getShardTransactionCommitTimeoutInSeconds(), (TimeUnit)TimeUnit.SECONDS));
        this.shardInitializationTimeout = new Timeout(this.datastoreContext.getShardInitializationTimeout().duration().$times(2L));
    }

    public DatastoreContext getDatastoreContext() {
        return this.datastoreContext;
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public ActorRef getShardManager() {
        return this.shardManager;
    }

    public ActorSelection actorSelection(String actorPath) {
        return this.actorSystem.actorSelection(actorPath);
    }

    public ActorSelection actorSelection(ActorPath actorPath) {
        return this.actorSystem.actorSelection(actorPath);
    }

    public void setSchemaContext(SchemaContext schemaContext) {
        this.schemaContext = schemaContext;
        if (this.shardManager != null) {
            this.shardManager.tell((Object)new UpdateSchemaContext(schemaContext), ActorRef.noSender());
        }
    }

    public void setDatastoreContext(DatastoreContextFactory contextFactory) {
        this.datastoreContext = contextFactory.getBaseDatastoreContext();
        this.setCachedProperties();
        this.updated = true;
        if (this.shardManager != null) {
            this.shardManager.tell((Object)contextFactory, ActorRef.noSender());
        }
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public Future<PrimaryShardInfo> findPrimaryShardAsync(final String shardName) {
        Future<PrimaryShardInfo> ret = this.primaryShardInfoCache.getIfPresent(shardName);
        if (ret != null) {
            return ret;
        }
        Future<Object> future = this.executeOperationAsync(this.shardManager, (Object)new FindPrimary(shardName, true), this.shardInitializationTimeout);
        return future.transform((Function1)new Mapper<Object, PrimaryShardInfo>(){

            public PrimaryShardInfo checkedApply(Object response) throws UnknownMessageException {
                if (response instanceof RemotePrimaryShardFound) {
                    LOG.debug("findPrimaryShardAsync received: {}", response);
                    RemotePrimaryShardFound found = (RemotePrimaryShardFound)response;
                    return ActorContext.this.onPrimaryShardFound(shardName, found.getPrimaryPath(), found.getPrimaryVersion(), null);
                }
                if (response instanceof LocalPrimaryShardFound) {
                    LOG.debug("findPrimaryShardAsync received: {}", response);
                    LocalPrimaryShardFound found = (LocalPrimaryShardFound)response;
                    return ActorContext.this.onPrimaryShardFound(shardName, found.getPrimaryPath(), (short)9, found.getLocalShardDataTree());
                }
                if (response instanceof NotInitializedException) {
                    throw (NotInitializedException)response;
                }
                if (response instanceof PrimaryNotFoundException) {
                    throw (PrimaryNotFoundException)response;
                }
                if (response instanceof NoShardLeaderException) {
                    throw (NoShardLeaderException)response;
                }
                throw new UnknownMessageException((Object)String.format("FindPrimary returned unkown response: %s", response));
            }
        }, FIND_PRIMARY_FAILURE_TRANSFORMER, this.getClientDispatcher());
    }

    private PrimaryShardInfo onPrimaryShardFound(String shardName, String primaryActorPath, short primaryVersion, DataTree localShardDataTree) {
        ActorSelection actorSelection = this.actorSystem.actorSelection(primaryActorPath);
        PrimaryShardInfo info = localShardDataTree == null ? new PrimaryShardInfo(actorSelection, primaryVersion) : new PrimaryShardInfo(actorSelection, primaryVersion, localShardDataTree);
        this.primaryShardInfoCache.putSuccessful(shardName, info);
        return info;
    }

    public Optional<ActorRef> findLocalShard(String shardName) {
        Object result = this.executeOperation(this.shardManager, (Object)new FindLocalShard(shardName, false));
        if (result instanceof LocalShardFound) {
            LocalShardFound found = (LocalShardFound)result;
            LOG.debug("Local shard found {}", (Object)found.getPath());
            return Optional.of((Object)found.getPath());
        }
        return Optional.absent();
    }

    public Future<ActorRef> findLocalShardAsync(final String shardName) {
        Future<Object> future = this.executeOperationAsync(this.shardManager, (Object)new FindLocalShard(shardName, true), this.shardInitializationTimeout);
        return future.map((Function1)new Mapper<Object, ActorRef>(){

            public ActorRef checkedApply(Object response) throws Throwable {
                if (response instanceof LocalShardFound) {
                    LocalShardFound found = (LocalShardFound)response;
                    LOG.debug("Local shard found {}", (Object)found.getPath());
                    return found.getPath();
                }
                if (response instanceof NotInitializedException) {
                    throw (NotInitializedException)response;
                }
                if (response instanceof LocalShardNotFound) {
                    throw new LocalShardNotFoundException(String.format("Local shard for %s does not exist.", shardName));
                }
                throw new UnknownMessageException((Object)String.format("FindLocalShard returned unkown response: %s", response));
            }
        }, this.getClientDispatcher());
    }

    public Object executeOperation(ActorRef actor, Object message) {
        Future<Object> future = this.executeOperationAsync(actor, message, this.operationTimeout);
        try {
            return Await.result(future, (Duration)this.operationDuration);
        }
        catch (Exception e) {
            throw new TimeoutException("Sending message " + message.getClass().toString() + " to actor " + actor.toString() + " failed. Try again later.", e);
        }
    }

    public Object executeOperation(ActorSelection actor, Object message) {
        Future<Object> future = this.executeOperationAsync(actor, message);
        try {
            return Await.result(future, (Duration)this.operationDuration);
        }
        catch (Exception e) {
            throw new TimeoutException("Sending message " + message.getClass().toString() + " to actor " + actor.toString() + " failed. Try again later.", e);
        }
    }

    public Future<Object> executeOperationAsync(ActorRef actor, Object message, Timeout timeout) {
        Preconditions.checkArgument((actor != null ? 1 : 0) != 0, (Object)"actor must not be null");
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message must not be null");
        LOG.debug("Sending message {} to {}", message.getClass(), (Object)actor);
        return this.doAsk(actor, message, timeout);
    }

    public Future<Object> executeOperationAsync(ActorSelection actor, Object message, Timeout timeout) {
        Preconditions.checkArgument((actor != null ? 1 : 0) != 0, (Object)"actor must not be null");
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message must not be null");
        LOG.debug("Sending message {} to {}", message.getClass(), (Object)actor);
        return this.doAsk(actor, message, timeout);
    }

    public Future<Object> executeOperationAsync(ActorSelection actor, Object message) {
        return this.executeOperationAsync(actor, message, this.operationTimeout);
    }

    public void sendOperationAsync(ActorSelection actor, Object message) {
        Preconditions.checkArgument((actor != null ? 1 : 0) != 0, (Object)"actor must not be null");
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message must not be null");
        LOG.debug("Sending message {} to {}", message.getClass(), (Object)actor);
        actor.tell(message, ActorRef.noSender());
    }

    public void shutdown() {
        FiniteDuration duration = this.datastoreContext.getShardRaftConfig().getElectionTimeOutInterval().$times(3L);
        try {
            Await.ready((Awaitable)Patterns.gracefulStop((ActorRef)this.shardManager, (FiniteDuration)duration, (Object)Shutdown.INSTANCE), (Duration)duration);
        }
        catch (Exception e) {
            LOG.warn("ShardManager for {} data store did not shutdown gracefully", (Object)this.getDataStoreName(), (Object)e);
        }
    }

    public ClusterWrapper getClusterWrapper() {
        return this.clusterWrapper;
    }

    public MemberName getCurrentMemberName() {
        return this.clusterWrapper.getCurrentMemberName();
    }

    public void broadcast(final Function<Short, Object> messageSupplier, final Class<?> messageClass) {
        for (final String shardName : this.configuration.getAllShardNames()) {
            Future<PrimaryShardInfo> primaryFuture = this.findPrimaryShardAsync(shardName);
            primaryFuture.onComplete((Function1)new OnComplete<PrimaryShardInfo>(){

                public void onComplete(Throwable failure, PrimaryShardInfo primaryShardInfo) {
                    if (failure != null) {
                        LOG.warn("broadcast failed to send message {} to shard {}", new Object[]{messageClass.getSimpleName(), shardName, failure});
                    } else {
                        Object message = messageSupplier.apply(primaryShardInfo.getPrimaryShardVersion());
                        primaryShardInfo.getPrimaryShardActor().tell(message, ActorRef.noSender());
                    }
                }
            }, this.getClientDispatcher());
        }
    }

    public FiniteDuration getOperationDuration() {
        return this.operationDuration;
    }

    public Timeout getOperationTimeout() {
        return this.operationTimeout;
    }

    public boolean isPathLocal(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return false;
        }
        int pathAtIndex = path.indexOf(64);
        if (pathAtIndex == -1) {
            return true;
        }
        if (this.selfAddressHostPort != null) {
            int slashIndex = path.indexOf(47, pathAtIndex);
            if (slashIndex == -1) {
                return false;
            }
            String hostPort = path.substring(pathAtIndex + 1, slashIndex);
            return hostPort.equals(this.selfAddressHostPort);
        }
        return false;
    }

    public Timer getOperationTimer(String operationName) {
        return this.getOperationTimer(this.datastoreContext.getDataStoreName(), operationName);
    }

    public Timer getOperationTimer(String dataStoreType, String operationName) {
        String rate = MetricRegistry.name((String)DISTRIBUTED_DATA_STORE_METRIC_REGISTRY, (String[])new String[]{dataStoreType, operationName, METRIC_RATE});
        return this.metricRegistry.timer(rate);
    }

    public String getDataStoreName() {
        return this.datastoreContext.getDataStoreName();
    }

    public double getTxCreationLimit() {
        return this.txRateLimiter.getTxCreationLimit();
    }

    public void acquireTxCreationPermit() {
        this.txRateLimiter.acquire();
    }

    public Timeout getTransactionCommitOperationTimeout() {
        return this.transactionCommitOperationTimeout;
    }

    public ExecutionContext getClientDispatcher() {
        return this.dispatchers.getDispatcher(Dispatchers.DispatcherType.Client);
    }

    public String getNotificationDispatcherPath() {
        return this.dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Notification);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ShardStrategyFactory getShardStrategyFactory() {
        return this.shardStrategyFactory;
    }

    protected Future<Object> doAsk(ActorRef actorRef, Object message, Timeout timeout) {
        return Patterns.ask((ActorRef)actorRef, (Object)message, (Timeout)timeout);
    }

    protected Future<Object> doAsk(ActorSelection actorRef, Object message, Timeout timeout) {
        return Patterns.ask((ActorSelection)actorRef, (Object)message, (Timeout)timeout);
    }

    public PrimaryShardInfoFutureCache getPrimaryShardInfoCache() {
        return this.primaryShardInfoCache;
    }
}

