/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.Status;
import akka.actor.UntypedAbstractActor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshotReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

final class ShardManagerGetSnapshotReplyActor
extends UntypedAbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(ShardManagerGetSnapshotReplyActor.class);
    private final Set<String> remainingShardNames;
    private final Params params;
    private final List<DatastoreSnapshot.ShardSnapshot> shardSnapshots = new ArrayList<DatastoreSnapshot.ShardSnapshot>();

    private ShardManagerGetSnapshotReplyActor(Params params) {
        this.params = params;
        this.remainingShardNames = new HashSet<String>(params.shardNames);
        LOG.debug("{}: Expecting {} shard snapshot replies", (Object)params.id, (Object)params.shardNames.size());
        this.getContext().setReceiveTimeout((Duration)params.receiveTimeout);
    }

    public void onReceive(Object message) {
        if (message instanceof GetSnapshotReply) {
            this.onGetSnapshotReply((GetSnapshotReply)message);
        } else if (message instanceof Status.Failure) {
            LOG.debug("{}: Received {}", (Object)this.params.id, message);
            this.params.replyToActor.tell(message, this.getSelf());
            this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
        } else if (message instanceof ReceiveTimeout) {
            LOG.warn("{}: Timed out after {} ms while waiting for snapshot replies from {} shard(s). {} shard(s) {} did not respond", new Object[]{this.params.id, this.params.receiveTimeout.toMillis(), this.params.shardNames.size(), this.remainingShardNames.size(), this.remainingShardNames});
            this.params.replyToActor.tell((Object)new Status.Failure((Throwable)new TimeoutException(String.format("Timed out after %s ms while waiting for snapshot replies from %d shard(s). %d shard(s) %s did not respond.", this.params.receiveTimeout.toMillis(), this.params.shardNames.size(), this.remainingShardNames.size(), this.remainingShardNames))), this.getSelf());
            this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
        }
    }

    private void onGetSnapshotReply(GetSnapshotReply getSnapshotReply) {
        LOG.debug("{}: Received {}", (Object)this.params.id, (Object)getSnapshotReply);
        ShardIdentifier shardId = ShardIdentifier.fromShardIdString(getSnapshotReply.getId());
        this.shardSnapshots.add(new DatastoreSnapshot.ShardSnapshot(shardId.getShardName(), getSnapshotReply.getSnapshot()));
        this.remainingShardNames.remove(shardId.getShardName());
        if (this.remainingShardNames.isEmpty()) {
            LOG.debug("{}: All shard snapshots received", (Object)this.params.id);
            DatastoreSnapshot datastoreSnapshot = new DatastoreSnapshot(this.params.datastoreType, this.params.shardManagerSnapshot, this.shardSnapshots);
            this.params.replyToActor.tell((Object)datastoreSnapshot, this.getSelf());
            this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
        }
    }

    public static Props props(Collection<String> shardNames, String datastoreType, ShardManagerSnapshot shardManagerSnapshot, ActorRef replyToActor, String id, FiniteDuration receiveTimeout) {
        return Props.create(ShardManagerGetSnapshotReplyActor.class, (Object[])new Object[]{new Params(shardNames, datastoreType, shardManagerSnapshot, replyToActor, id, receiveTimeout)});
    }

    private static final class Params {
        final Collection<String> shardNames;
        final String datastoreType;
        final ShardManagerSnapshot shardManagerSnapshot;
        final ActorRef replyToActor;
        final String id;
        final FiniteDuration receiveTimeout;

        Params(Collection<String> shardNames, String datastoreType, ShardManagerSnapshot shardManagerSnapshot, ActorRef replyToActor, String id, FiniteDuration receiveTimeout) {
            this.shardNames = shardNames;
            this.datastoreType = datastoreType;
            this.shardManagerSnapshot = shardManagerSnapshot;
            this.replyToActor = replyToActor;
            this.id = id;
            this.receiveTimeout = receiveTimeout;
        }
    }
}

