/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.primitives.UnsignedLong;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.concepts.WritableObjects;

public final class FrontendClientMetadata
implements Identifiable<ClientIdentifier>,
WritableObject {
    private final Collection<FrontendHistoryMetadata> currentHistories;
    private final RangeSet<UnsignedLong> purgedHistories;
    private final ClientIdentifier identifier;

    public FrontendClientMetadata(ClientIdentifier identifier, RangeSet<UnsignedLong> purgedHistories, Collection<FrontendHistoryMetadata> currentHistories) {
        this.identifier = (ClientIdentifier)Preconditions.checkNotNull((Object)identifier);
        this.purgedHistories = ImmutableRangeSet.copyOf(purgedHistories);
        this.currentHistories = ImmutableList.copyOf(currentHistories);
    }

    public Collection<FrontendHistoryMetadata> getCurrentHistories() {
        return this.currentHistories;
    }

    public RangeSet<UnsignedLong> getPurgedHistories() {
        return this.purgedHistories;
    }

    public ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    public void writeTo(DataOutput out) throws IOException {
        this.identifier.writeTo(out);
        Set ranges = this.purgedHistories.asRanges();
        out.writeInt(ranges.size());
        for (Range r : ranges) {
            WritableObjects.writeLongs((DataOutput)out, (long)((UnsignedLong)r.lowerEndpoint()).longValue(), (long)((UnsignedLong)r.upperEndpoint()).longValue());
        }
        out.writeInt(this.currentHistories.size());
        for (FrontendHistoryMetadata h : this.currentHistories) {
            h.writeTo(out);
        }
    }

    public static FrontendClientMetadata readFrom(DataInput in) throws IOException {
        ClientIdentifier id = ClientIdentifier.readFrom((DataInput)in);
        int purgedSize = in.readInt();
        ImmutableRangeSet.Builder b = ImmutableRangeSet.builder();
        for (int i = 0; i < purgedSize; ++i) {
            byte header = WritableObjects.readLongHeader((DataInput)in);
            UnsignedLong lower = UnsignedLong.fromLongBits((long)WritableObjects.readFirstLong((DataInput)in, (byte)header));
            UnsignedLong upper = UnsignedLong.fromLongBits((long)WritableObjects.readSecondLong((DataInput)in, (byte)header));
            b.add(Range.closed((Comparable)lower, (Comparable)upper));
        }
        int currentSize = in.readInt();
        ArrayList<FrontendHistoryMetadata> currentHistories = new ArrayList<FrontendHistoryMetadata>(currentSize);
        for (int i = 0; i < currentSize; ++i) {
            currentHistories.add(FrontendHistoryMetadata.readFrom(in));
        }
        return new FrontendClientMetadata(id, (RangeSet<UnsignedLong>)b.build(), currentHistories);
    }

    public String toString() {
        return MoreObjects.toStringHelper(FrontendClientMetadata.class).add("identifer", (Object)this.identifier).add("current", this.currentHistories).add("purged", this.purgedHistories).toString();
    }
}

