/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.DataTreeCandidateInputOutput;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class CommitTransactionPayload
extends Payload
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CommitTransactionPayload.class);
    private static final long serialVersionUID = 1L;
    private final byte[] serialized;

    CommitTransactionPayload(byte[] serialized) {
        this.serialized = (byte[])Preconditions.checkNotNull((Object)serialized);
    }

    public static CommitTransactionPayload create(TransactionIdentifier transactionId, DataTreeCandidate candidate, int initialSerializedBufferCapacity) throws IOException {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        transactionId.writeTo((DataOutput)out);
        DataTreeCandidateInputOutput.writeDataTreeCandidate((DataOutput)out, candidate);
        byte[] serialized = out.toByteArray();
        LOG.debug("Initial buffer capacity {}, actual serialized size {}", (Object)initialSerializedBufferCapacity, (Object)serialized.length);
        return new CommitTransactionPayload(serialized);
    }

    @VisibleForTesting
    public static CommitTransactionPayload create(TransactionIdentifier transactionId, DataTreeCandidate candidate) throws IOException {
        return CommitTransactionPayload.create(transactionId, candidate, 512);
    }

    public Map.Entry<TransactionIdentifier, DataTreeCandidate> getCandidate() throws IOException {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])this.serialized);
        return new AbstractMap.SimpleImmutableEntry<TransactionIdentifier, DataTreeCandidate>(TransactionIdentifier.readFrom((DataInput)in), DataTreeCandidateInputOutput.readDataTreeCandidate((DataInput)in));
    }

    public int size() {
        return this.serialized.length;
    }

    private Object writeReplace() {
        return new Proxy(this.serialized);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private byte[] serialized;

        public Proxy() {
        }

        Proxy(byte[] serialized) {
            this.serialized = (byte[])Preconditions.checkNotNull((Object)serialized);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.serialized.length);
            out.write(this.serialized);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            int length = in.readInt();
            this.serialized = new byte[length];
            in.readFully(this.serialized);
        }

        private Object readResolve() {
            return new CommitTransactionPayload(this.serialized);
        }
    }
}

