/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;

@Beta
public abstract class AbstractVersionException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final PayloadVersion closestVersion;
    private final int version;

    AbstractVersionException(String message, short version, PayloadVersion closestVersion) {
        super(message);
        this.closestVersion = (PayloadVersion)((Object)Preconditions.checkNotNull((Object)((Object)closestVersion)));
        this.version = Short.toUnsignedInt(version);
    }

    public final int getVersion() {
        return this.version;
    }

    @Nonnull
    public final PayloadVersion getClosestVersion() {
        return this.closestVersion;
    }
}

