/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.OnDemandShardStateCache;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardDataTreeListenerInfoMXBean;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeListenerInfo;
import org.opendaylight.controller.cluster.datastore.messages.GetInfo;
import org.opendaylight.controller.cluster.datastore.messages.OnDemandShardState;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class ShardDataTreeListenerInfoMXBeanImpl
extends AbstractMXBean
implements ShardDataTreeListenerInfoMXBean {
    private static final String JMX_CATEGORY = "ShardDataTreeListenerInfo";
    private final OnDemandShardStateCache stateCache;

    public ShardDataTreeListenerInfoMXBeanImpl(String shardName, String mxBeanType, ActorRef shardActor) {
        super(shardName, mxBeanType, JMX_CATEGORY);
        this.stateCache = new OnDemandShardStateCache(shardName, (ActorRef)Preconditions.checkNotNull((Object)shardActor));
    }

    @Override
    public List<DataTreeListenerInfo> getDataTreeChangeListenerInfo() {
        return this.getListenerActorsInfo(this.getState().getTreeChangeListenerActors());
    }

    private OnDemandShardState getState() {
        try {
            return this.stateCache.get();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<DataTreeListenerInfo> getListenerActorsInfo(Collection<ActorSelection> actors) {
        Timeout timeout = new Timeout(20L, TimeUnit.SECONDS);
        ArrayList<Future> futureList = new ArrayList<Future>(actors.size());
        for (ActorSelection actor : actors) {
            futureList.add(Patterns.ask((ActorSelection)actor, (Object)GetInfo.INSTANCE, (Timeout)timeout));
        }
        try {
            ArrayList<DataTreeListenerInfo> listenerInfoList = new ArrayList<DataTreeListenerInfo>();
            ((Iterable)Await.result((Awaitable)Futures.sequence(futureList, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)timeout.duration())).forEach(obj -> listenerInfoList.add((DataTreeListenerInfo)obj));
            return listenerInfoList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

