/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership.messages;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategy;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class SelectOwner {
    private final YangInstanceIdentifier entityPath;
    private final Collection<String> allCandidates;
    private final EntityOwnerSelectionStrategy ownerSelectionStrategy;

    public SelectOwner(YangInstanceIdentifier entityPath, Collection<String> allCandidates, EntityOwnerSelectionStrategy ownerSelectionStrategy) {
        this.entityPath = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)entityPath, (Object)"entityPath should not be null");
        this.allCandidates = (Collection)Preconditions.checkNotNull(allCandidates, (Object)"allCandidates should not be null");
        this.ownerSelectionStrategy = (EntityOwnerSelectionStrategy)Preconditions.checkNotNull((Object)ownerSelectionStrategy, (Object)"ownerSelectionStrategy should not be null");
    }

    public YangInstanceIdentifier getEntityPath() {
        return this.entityPath;
    }

    public Collection<String> getAllCandidates() {
        return this.allCandidates;
    }

    public EntityOwnerSelectionStrategy getOwnerSelectionStrategy() {
        return this.ownerSelectionStrategy;
    }

    public String toString() {
        return "SelectOwner [entityPath=" + this.entityPath + ", allCandidates=" + this.allCandidates + ", ownerSelectionStrategy=" + this.ownerSelectionStrategy + "]";
    }
}

