/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Cancellable;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.pattern.Patterns;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.entityownership.CandidateListChangeListener;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnerChangeListener;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnersModel;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnershipListenerSupport;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnershipShardCommitCoordinator;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnershipStatistics;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.CandidateAdded;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.CandidateRemoved;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.RegisterCandidateLocal;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.RegisterListenerLocal;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.RemoveAllCandidates;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.SelectOwner;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.UnregisterCandidateLocal;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.UnregisterListenerLocal;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategy;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategyConfig;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.PeerDown;
import org.opendaylight.controller.cluster.datastore.messages.PeerUp;
import org.opendaylight.controller.cluster.datastore.messages.SuccessReply;
import org.opendaylight.controller.cluster.datastore.modification.DeleteModification;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.VotingState;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

class EntityOwnershipShard
extends Shard {
    private final MemberName localMemberName;
    private final EntityOwnershipShardCommitCoordinator commitCoordinator;
    private final EntityOwnershipListenerSupport listenerSupport;
    private final Set<MemberName> downPeerMemberNames = new HashSet<MemberName>();
    private final EntityOwnerSelectionStrategyConfig strategyConfig;
    private final Map<YangInstanceIdentifier, Cancellable> entityToScheduledOwnershipTask = new HashMap<YangInstanceIdentifier, Cancellable>();
    private final EntityOwnershipStatistics entityOwnershipStatistics;
    private boolean removeAllInitialCandidates = true;

    protected EntityOwnershipShard(Builder builder) {
        super(builder);
        this.localMemberName = builder.localMemberName;
        this.commitCoordinator = new EntityOwnershipShardCommitCoordinator(builder.localMemberName, this.LOG);
        this.listenerSupport = new EntityOwnershipListenerSupport((ActorContext)this.getContext(), this.persistenceId());
        this.strategyConfig = builder.ownerSelectionStrategyConfig;
        this.entityOwnershipStatistics = new EntityOwnershipStatistics();
        this.entityOwnershipStatistics.init(this.getDataStore());
    }

    private static DatastoreContext noPersistenceDatastoreContext(DatastoreContext datastoreContext) {
        return DatastoreContext.newBuilderFrom(datastoreContext).persistent(false).build();
    }

    @Override
    protected void onDatastoreContext(DatastoreContext context) {
        super.onDatastoreContext(EntityOwnershipShard.noPersistenceDatastoreContext(context));
    }

    @Override
    protected void onRecoveryComplete() {
        super.onRecoveryComplete();
        new CandidateListChangeListener(this.getSelf(), this.persistenceId()).init(this.getDataStore());
        new EntityOwnerChangeListener(this.localMemberName, this.listenerSupport).init(this.getDataStore());
    }

    @Override
    public void handleNonRaftCommand(Object message) {
        if (message instanceof RegisterCandidateLocal) {
            this.onRegisterCandidateLocal((RegisterCandidateLocal)message);
        } else if (message instanceof UnregisterCandidateLocal) {
            this.onUnregisterCandidateLocal((UnregisterCandidateLocal)message);
        } else if (message instanceof CandidateAdded) {
            this.onCandidateAdded((CandidateAdded)message);
        } else if (message instanceof CandidateRemoved) {
            this.onCandidateRemoved((CandidateRemoved)message);
        } else if (message instanceof PeerDown) {
            this.onPeerDown((PeerDown)message);
        } else if (message instanceof PeerUp) {
            this.onPeerUp((PeerUp)message);
        } else if (message instanceof RegisterListenerLocal) {
            this.onRegisterListenerLocal((RegisterListenerLocal)message);
        } else if (message instanceof UnregisterListenerLocal) {
            this.onUnregisterListenerLocal((UnregisterListenerLocal)message);
        } else if (message instanceof SelectOwner) {
            this.onSelectOwner((SelectOwner)message);
        } else if (message instanceof RemoveAllCandidates) {
            this.onRemoveAllCandidates((RemoveAllCandidates)message);
        } else if (!this.commitCoordinator.handleMessage(message, this)) {
            super.handleNonRaftCommand(message);
        }
    }

    private void onRemoveAllCandidates(RemoveAllCandidates message) {
        this.LOG.debug("{}: onRemoveAllCandidates: {}", (Object)this.persistenceId(), (Object)message);
        this.removeCandidateFromEntities(message.getMemberName());
    }

    private void onSelectOwner(SelectOwner selectOwner) {
        this.LOG.debug("{}: onSelectOwner: {}", (Object)this.persistenceId(), (Object)selectOwner);
        String currentOwner = this.getCurrentOwner(selectOwner.getEntityPath());
        if (Strings.isNullOrEmpty((String)currentOwner)) {
            this.writeNewOwner(selectOwner.getEntityPath(), this.newOwner(currentOwner, selectOwner.getAllCandidates(), selectOwner.getOwnerSelectionStrategy()));
            Cancellable cancellable = this.entityToScheduledOwnershipTask.get(selectOwner.getEntityPath());
            if (cancellable != null) {
                if (!cancellable.isCancelled()) {
                    cancellable.cancel();
                }
                this.entityToScheduledOwnershipTask.remove(selectOwner.getEntityPath());
            }
        }
    }

    private void onRegisterCandidateLocal(RegisterCandidateLocal registerCandidate) {
        this.LOG.debug("{}: onRegisterCandidateLocal: {}", (Object)this.persistenceId(), (Object)registerCandidate);
        NormalizedNode<?, ?> entityOwners = EntityOwnersModel.entityOwnersWithCandidate(registerCandidate.getEntity().getType(), (YangInstanceIdentifier)registerCandidate.getEntity().getIdentifier(), this.localMemberName.getName());
        this.commitCoordinator.commitModification(new MergeModification(EntityOwnersModel.ENTITY_OWNERS_PATH, entityOwners), this);
        this.getSender().tell((Object)SuccessReply.INSTANCE, this.getSelf());
    }

    private void onUnregisterCandidateLocal(UnregisterCandidateLocal unregisterCandidate) {
        this.LOG.debug("{}: onUnregisterCandidateLocal: {}", (Object)this.persistenceId(), (Object)unregisterCandidate);
        DOMEntity entity = unregisterCandidate.getEntity();
        YangInstanceIdentifier candidatePath = EntityOwnersModel.candidatePath(entity.getType(), (YangInstanceIdentifier)entity.getIdentifier(), this.localMemberName.getName());
        this.commitCoordinator.commitModification(new DeleteModification(candidatePath), this);
        this.getSender().tell((Object)SuccessReply.INSTANCE, this.getSelf());
    }

    private void onRegisterListenerLocal(RegisterListenerLocal registerListener) {
        this.LOG.debug("{}: onRegisterListenerLocal: {}", (Object)this.persistenceId(), (Object)registerListener);
        this.listenerSupport.addEntityOwnershipListener(registerListener.getEntityType(), registerListener.getListener());
        this.getSender().tell((Object)SuccessReply.INSTANCE, this.getSelf());
        this.searchForEntities((entityTypeNode, entityNode) -> {
            String entityType;
            Optional possibleType = entityTypeNode.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_TYPE_NODE_ID);
            String string = entityType = possibleType.isPresent() ? ((DataContainerChild)possibleType.get()).getValue().toString() : null;
            if (registerListener.getEntityType().equals(entityType)) {
                boolean hasOwner;
                boolean isOwner;
                Optional possibleOwner = entityNode.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_OWNER_NODE_ID);
                if (possibleOwner.isPresent()) {
                    isOwner = this.localMemberName.getName().equals(((DataContainerChild)possibleOwner.get()).getValue().toString());
                    hasOwner = true;
                } else {
                    isOwner = false;
                    hasOwner = false;
                }
                DOMEntity entity = new DOMEntity(entityType, (YangInstanceIdentifier)((DataContainerChild)entityNode.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_ID_NODE_ID).get()).getValue());
                this.listenerSupport.notifyEntityOwnershipListener(entity, false, isOwner, hasOwner, registerListener.getListener());
            }
        });
    }

    private void onUnregisterListenerLocal(UnregisterListenerLocal unregisterListener) {
        this.LOG.debug("{}: onUnregisterListenerLocal: {}", (Object)this.persistenceId(), (Object)unregisterListener);
        this.listenerSupport.removeEntityOwnershipListener(unregisterListener.getEntityType(), unregisterListener.getListener());
        this.getSender().tell((Object)SuccessReply.INSTANCE, this.getSelf());
    }

    void tryCommitModifications(BatchedModifications modifications) {
        if (this.isLeader()) {
            this.LOG.debug("{}: Committing BatchedModifications {} locally", (Object)this.persistenceId(), (Object)modifications.getTransactionId());
            this.handleBatchedModificationsLocal(modifications, this.self());
        } else {
            ActorSelection leader = this.getLeader();
            if (leader != null) {
                this.possiblyRemoveAllInitialCandidates(leader);
                this.LOG.debug("{}: Sending BatchedModifications {} to leader {}", new Object[]{this.persistenceId(), modifications.getTransactionId(), leader});
                Future future = Patterns.ask((ActorSelection)leader, (Object)modifications, (long)TimeUnit.SECONDS.toMillis(this.getDatastoreContext().getShardTransactionCommitTimeoutInSeconds()));
                Patterns.pipe((Future)future, (ExecutionContext)this.getContext().dispatcher()).pipeTo(this.getSelf(), ActorRef.noSender());
            }
        }
    }

    void possiblyRemoveAllInitialCandidates(ActorSelection leader) {
        if (this.removeAllInitialCandidates && leader != null) {
            this.removeAllInitialCandidates = false;
            if (!this.isLeader()) {
                this.LOG.debug("{} - got new leader {} on startup - sending RemoveAllCandidates", (Object)this.persistenceId(), (Object)leader);
                leader.tell((Object)new RemoveAllCandidates(this.localMemberName), ActorRef.noSender());
            }
        }
    }

    boolean hasLeader() {
        return this.getLeader() != null && (!this.isLeader() || this.isLeaderActive());
    }

    private static boolean inJeopardy(RaftState state) {
        switch (state) {
            case Candidate: 
            case Follower: 
            case Leader: 
            case PreLeader: {
                return false;
            }
            case IsolatedLeader: {
                return true;
            }
        }
        throw new IllegalStateException("Unsupported RAFT state " + state);
    }

    private void notifyAllListeners() {
        this.searchForEntities((entityTypeNode, entityNode) -> {
            Optional possibleType = entityTypeNode.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_TYPE_NODE_ID);
            if (possibleType.isPresent()) {
                boolean hasOwner;
                boolean isOwner;
                Optional possibleOwner = entityNode.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_OWNER_NODE_ID);
                if (possibleOwner.isPresent()) {
                    isOwner = this.localMemberName.getName().equals(((DataContainerChild)possibleOwner.get()).getValue().toString());
                    hasOwner = true;
                } else {
                    isOwner = false;
                    hasOwner = false;
                }
                DOMEntity entity = new DOMEntity(((DataContainerChild)possibleType.get()).getValue().toString(), (YangInstanceIdentifier)((DataContainerChild)entityNode.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_ID_NODE_ID).get()).getValue());
                this.listenerSupport.notifyEntityOwnershipListeners(entity, isOwner, isOwner, hasOwner);
            }
        });
    }

    @Override
    protected void onStateChanged() {
        boolean isLeader = this.isLeader();
        this.LOG.debug("{}: onStateChanged: isLeader: {}, hasLeader: {}", new Object[]{this.persistenceId(), isLeader, this.hasLeader()});
        boolean inJeopardy = EntityOwnershipShard.inJeopardy(this.getRaftState());
        boolean wasInJeopardy = this.listenerSupport.setInJeopardy(inJeopardy);
        if (inJeopardy != wasInJeopardy) {
            this.LOG.debug("{}: {} jeopardy state, notifying all listeners", (Object)this.persistenceId(), (Object)(inJeopardy ? "entered" : "left"));
            this.notifyAllListeners();
        }
        this.commitCoordinator.onStateChanged(this, isLeader);
        super.onStateChanged();
    }

    @Override
    protected void onLeaderChanged(String oldLeader, String newLeader) {
        boolean isLeader = this.isLeader();
        this.LOG.debug("{}: onLeaderChanged: oldLeader: {}, newLeader: {}, isLeader: {}", new Object[]{this.persistenceId(), oldLeader, newLeader, isLeader});
        if (isLeader) {
            this.initializeDownPeerMemberNamesFromClusterState();
            this.strategyConfig.clearStrategies();
            HashSet<String> ownedBy = new HashSet<String>(this.downPeerMemberNames.size() + 1);
            for (MemberName downPeerName : this.downPeerMemberNames) {
                ownedBy.add(downPeerName.getName());
            }
            ownedBy.add("");
            this.selectNewOwnerForEntitiesOwnedBy(ownedBy);
        } else {
            this.commitCoordinator.onStateChanged(this, isLeader);
        }
        super.onLeaderChanged(oldLeader, newLeader);
    }

    protected void onVotingStateChangeComplete() {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        this.searchForEntities((entityTypeNode, entityNode) -> {
            YangInstanceIdentifier entityPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)EntityOwnersModel.ENTITY_TYPES_PATH).node((YangInstanceIdentifier.PathArgument)entityTypeNode.getIdentifier()).node((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_NODE_ID).node((YangInstanceIdentifier.PathArgument)entityNode.getIdentifier()).node((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_OWNER_NODE_ID).build();
            Optional<String> possibleOwner = entityNode.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_OWNER_NODE_ID).map(node -> node.getValue().toString());
            String newOwner = this.newOwner(possibleOwner.orElse(null), EntityOwnershipShard.getCandidateNames(entityNode), this.getEntityOwnerElectionStrategy(entityPath));
            if (!newOwner.equals(possibleOwner.orElse(""))) {
                modifications.add(new WriteModification(entityPath, (NormalizedNode<?, ?>)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)EntityOwnersModel.ENTITY_OWNER_NODE_ID, (Object)newOwner)));
            }
        });
        this.commitCoordinator.commitModifications(modifications, this);
    }

    private void initializeDownPeerMemberNamesFromClusterState() {
        Optional cluster = this.getRaftActorContext().getCluster();
        if (!cluster.isPresent()) {
            return;
        }
        ClusterEvent.CurrentClusterState state = ((Cluster)cluster.get()).state();
        Set unreachable = state.getUnreachable();
        this.LOG.debug("{}: initializeDownPeerMemberNamesFromClusterState - current downPeerMemberNames: {}, unreachable: {}", new Object[]{this.persistenceId(), this.downPeerMemberNames, unreachable});
        this.downPeerMemberNames.clear();
        for (Member m : unreachable) {
            this.downPeerMemberNames.add(MemberName.forName((String)((String)m.getRoles().iterator().next())));
        }
        for (Member m : state.getMembers()) {
            if (m.status() == MemberStatus.up() || m.status() == MemberStatus.weaklyUp()) continue;
            this.LOG.debug("{}: Adding down member with status {}", (Object)this.persistenceId(), (Object)m.status());
            this.downPeerMemberNames.add(MemberName.forName((String)((String)m.getRoles().iterator().next())));
        }
        this.LOG.debug("{}: new downPeerMemberNames: {}", (Object)this.persistenceId(), this.downPeerMemberNames);
    }

    private void onCandidateRemoved(CandidateRemoved message) {
        this.LOG.debug("{}: onCandidateRemoved: {}", (Object)this.persistenceId(), (Object)message);
        if (this.isLeader()) {
            String currentOwner = this.getCurrentOwner(message.getEntityPath());
            this.writeNewOwner(message.getEntityPath(), this.newOwner(currentOwner, message.getRemainingCandidates(), this.getEntityOwnerElectionStrategy(message.getEntityPath())));
        }
    }

    private EntityOwnerSelectionStrategy getEntityOwnerElectionStrategy(YangInstanceIdentifier entityPath) {
        String entityType = EntityOwnersModel.entityTypeFromEntityPath(entityPath);
        return this.strategyConfig.createStrategy(entityType, this.entityOwnershipStatistics.byEntityType(entityType));
    }

    private void onCandidateAdded(CandidateAdded message) {
        if (!this.isLeader()) {
            return;
        }
        this.LOG.debug("{}: onCandidateAdded: {}", (Object)this.persistenceId(), (Object)message);
        this.downPeerMemberNames.remove(MemberName.forName((String)message.getNewCandidate()));
        String currentOwner = this.getCurrentOwner(message.getEntityPath());
        EntityOwnerSelectionStrategy strategy = this.getEntityOwnerElectionStrategy(message.getEntityPath());
        int availableMembers = this.getRaftActorContext().getPeerIds().size() - this.downPeerMemberNames.size() + 1;
        this.LOG.debug("{}: Using strategy {} to select owner, currentOwner = {}", new Object[]{this.persistenceId(), strategy, currentOwner});
        if (strategy.getSelectionDelayInMillis() == 0L) {
            this.writeNewOwner(message.getEntityPath(), this.newOwner(currentOwner, message.getAllCandidates(), strategy));
        } else if (message.getAllCandidates().size() == availableMembers) {
            this.LOG.debug("{}: Received the maximum candidates requests : {} writing new owner", (Object)this.persistenceId(), (Object)availableMembers);
            this.cancelOwnerSelectionTask(message.getEntityPath());
            this.writeNewOwner(message.getEntityPath(), this.newOwner(currentOwner, message.getAllCandidates(), strategy));
        } else {
            this.scheduleOwnerSelection(message.getEntityPath(), message.getAllCandidates(), strategy);
        }
    }

    private void onPeerDown(PeerDown peerDown) {
        this.LOG.info("{}: onPeerDown: {}", (Object)this.persistenceId(), (Object)peerDown);
        MemberName downMemberName = peerDown.getMemberName();
        if (this.downPeerMemberNames.add(downMemberName) && this.isLeader()) {
            this.selectNewOwnerForEntitiesOwnedBy((Set<String>)ImmutableSet.of((Object)downMemberName.getName()));
        }
    }

    private void selectNewOwnerForEntitiesOwnedBy(Set<String> ownedBy) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        this.searchForEntitiesOwnedBy(ownedBy, (entityTypeNode, entityNode) -> {
            YangInstanceIdentifier entityPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)EntityOwnersModel.ENTITY_TYPES_PATH).node((YangInstanceIdentifier.PathArgument)entityTypeNode.getIdentifier()).node((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_NODE_ID).node((YangInstanceIdentifier.PathArgument)entityNode.getIdentifier()).node((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_OWNER_NODE_ID).build();
            String newOwner = this.newOwner(this.getCurrentOwner(entityPath), EntityOwnershipShard.getCandidateNames(entityNode), this.getEntityOwnerElectionStrategy(entityPath));
            if (!newOwner.isEmpty()) {
                this.LOG.debug("{}: Found entity {}, writing new owner {}", new Object[]{this.persistenceId(), entityPath, newOwner});
                modifications.add(new WriteModification(entityPath, (NormalizedNode<?, ?>)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)EntityOwnersModel.ENTITY_OWNER_NODE_ID, (Object)newOwner)));
            } else {
                this.LOG.debug("{}: Found entity {} but no other candidates - not clearing owner", (Object)this.persistenceId(), (Object)entityPath);
            }
        });
        this.commitCoordinator.commitModifications(modifications, this);
    }

    private void onPeerUp(PeerUp peerUp) {
        this.LOG.debug("{}: onPeerUp: {}", (Object)this.persistenceId(), (Object)peerUp);
        this.downPeerMemberNames.remove(peerUp.getMemberName());
        this.commitCoordinator.onStateChanged(this, this.isLeader());
        if (this.isLeader()) {
            this.selectNewOwnerForEntitiesOwnedBy((Set<String>)ImmutableSet.of((Object)""));
        }
    }

    private static Collection<String> getCandidateNames(MapEntryNode entity) {
        return entity.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.CANDIDATE_NODE_ID).map(child -> {
            Collection candidates = ((MapNode)child).getValue();
            ArrayList<String> candidateNames = new ArrayList<String>(candidates.size());
            for (MapEntryNode candidate : candidates) {
                candidateNames.add(((DataContainerChild)candidate.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.CANDIDATE_NAME_NODE_ID).get()).getValue().toString());
            }
            return candidateNames;
        }).orElse((Collection)ImmutableList.of());
    }

    private void searchForEntitiesOwnedBy(Set<String> ownedBy, EntityWalker walker) {
        this.LOG.debug("{}: Searching for entities owned by {}", (Object)this.persistenceId(), ownedBy);
        this.searchForEntities((entityTypeNode, entityNode) -> {
            String currentOwner;
            Optional possibleOwner = entityNode.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_OWNER_NODE_ID);
            String string = currentOwner = possibleOwner.isPresent() ? ((DataContainerChild)possibleOwner.get()).getValue().toString() : "";
            if (ownedBy.contains(currentOwner)) {
                walker.onEntity(entityTypeNode, entityNode);
            }
        });
    }

    private void removeCandidateFromEntities(MemberName member) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        this.searchForEntities((entityTypeNode, entityNode) -> {
            if (EntityOwnershipShard.hasCandidate(entityNode, member)) {
                YangInstanceIdentifier entityId = (YangInstanceIdentifier)entityNode.getIdentifier().getKeyValues().get(EntityOwnersModel.ENTITY_ID_QNAME);
                YangInstanceIdentifier candidatePath = EntityOwnersModel.candidatePath(entityTypeNode.getIdentifier().getKeyValues().get(EntityOwnersModel.ENTITY_TYPE_QNAME).toString(), entityId, member.getName());
                this.LOG.info("{}: Found entity {}, removing candidate {}, path {}", new Object[]{this.persistenceId(), entityId, member, candidatePath});
                modifications.add(new DeleteModification(candidatePath));
            }
        });
        this.commitCoordinator.commitModifications(modifications, this);
    }

    private static boolean hasCandidate(MapEntryNode entity, MemberName candidateName) {
        return entity.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.CANDIDATE_NODE_ID).flatMap(child -> ((MapNode)child).getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.candidateNodeKey(candidateName.getName()))).isPresent();
    }

    private void searchForEntities(EntityWalker walker) {
        com.google.common.base.Optional<NormalizedNode<?, ?>> possibleEntityTypes = this.getDataStore().readNode(EntityOwnersModel.ENTITY_TYPES_PATH);
        if (!possibleEntityTypes.isPresent()) {
            return;
        }
        for (MapEntryNode entityType : ((MapNode)possibleEntityTypes.get()).getValue()) {
            Optional possibleEntities = entityType.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_NODE_ID);
            if (!possibleEntities.isPresent()) continue;
            for (MapEntryNode entity : ((MapNode)possibleEntities.get()).getValue()) {
                walker.onEntity(entityType, entity);
            }
        }
    }

    private void writeNewOwner(YangInstanceIdentifier entityPath, String newOwner) {
        this.LOG.debug("{}: Writing new owner {} for entity {}", new Object[]{this.persistenceId(), newOwner, entityPath});
        this.commitCoordinator.commitModification(new WriteModification(entityPath.node(EntityOwnersModel.ENTITY_OWNER_QNAME), (NormalizedNode<?, ?>)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)EntityOwnersModel.ENTITY_OWNER_NODE_ID, (Object)newOwner)), this);
    }

    private void scheduleOwnerSelection(YangInstanceIdentifier entityPath, Collection<String> allCandidates, EntityOwnerSelectionStrategy strategy) {
        this.cancelOwnerSelectionTask(entityPath);
        this.LOG.debug("{}: Scheduling owner selection after {} ms", (Object)this.persistenceId(), (Object)strategy.getSelectionDelayInMillis());
        Cancellable lastScheduledTask = this.context().system().scheduler().scheduleOnce(FiniteDuration.apply((long)strategy.getSelectionDelayInMillis(), (TimeUnit)TimeUnit.MILLISECONDS), this.self(), (Object)new SelectOwner(entityPath, allCandidates, strategy), (ExecutionContext)this.context().system().dispatcher(), this.self());
        this.entityToScheduledOwnershipTask.put(entityPath, lastScheduledTask);
    }

    private void cancelOwnerSelectionTask(YangInstanceIdentifier entityPath) {
        Cancellable lastScheduledTask = this.entityToScheduledOwnershipTask.get(entityPath);
        if (lastScheduledTask != null && !lastScheduledTask.isCancelled()) {
            lastScheduledTask.cancel();
        }
    }

    private String newOwner(String currentOwner, Collection<String> candidates, EntityOwnerSelectionStrategy ownerSelectionStrategy) {
        Collection<String> viableCandidates = this.getViableCandidates(candidates);
        if (viableCandidates.isEmpty()) {
            return "";
        }
        return ownerSelectionStrategy.newOwner(currentOwner, viableCandidates);
    }

    private Collection<String> getViableCandidates(Collection<String> candidates) {
        HashMap memberToVotingState = new HashMap();
        this.getRaftActorContext().getPeers().forEach(peerInfo -> memberToVotingState.put(ShardIdentifier.fromShardIdString(peerInfo.getId()).getMemberName(), peerInfo.getVotingState()));
        ArrayList<String> viableCandidates = new ArrayList<String>();
        for (String candidate : candidates) {
            MemberName memberName = MemberName.forName((String)candidate);
            if (memberToVotingState.get(memberName) == VotingState.NON_VOTING || this.downPeerMemberNames.contains(memberName)) continue;
            viableCandidates.add(candidate);
        }
        return viableCandidates;
    }

    private String getCurrentOwner(YangInstanceIdentifier entityId) {
        com.google.common.base.Optional<NormalizedNode<?, ?>> optionalEntityOwner = this.getDataStore().readNode(entityId.node(EntityOwnersModel.ENTITY_OWNER_QNAME));
        if (optionalEntityOwner.isPresent()) {
            return ((NormalizedNode)optionalEntityOwner.get()).getValue().toString();
        }
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static class Builder
    extends Shard.AbstractBuilder<Builder, EntityOwnershipShard> {
        private MemberName localMemberName;
        private EntityOwnerSelectionStrategyConfig ownerSelectionStrategyConfig;

        protected Builder() {
            super(EntityOwnershipShard.class);
        }

        Builder localMemberName(MemberName newLocalMemberName) {
            this.checkSealed();
            this.localMemberName = newLocalMemberName;
            return this;
        }

        Builder ownerSelectionStrategyConfig(EntityOwnerSelectionStrategyConfig newOwnerSelectionStrategyConfig) {
            this.checkSealed();
            this.ownerSelectionStrategyConfig = newOwnerSelectionStrategyConfig;
            return this;
        }

        @Override
        protected void verify() {
            super.verify();
            Preconditions.checkNotNull((Object)this.localMemberName, (Object)"localMemberName should not be null");
            Preconditions.checkNotNull((Object)this.ownerSelectionStrategyConfig, (Object)"ownerSelectionStrategyConfig should not be null");
        }
    }

    @FunctionalInterface
    private static interface EntityWalker {
        public void onEntity(MapEntryNode var1, MapEntryNode var2);
    }
}

