/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership;

import java.util.Map;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.Candidate;
import org.opendaylight.yangtools.util.SharedSingletonMapTemplate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedMapNodeBuilder;

public final class EntityOwnersModel {
    static final QName ENTITY_QNAME = Entity.QNAME;
    static final QName CANDIDATE_NAME_QNAME = QName.create((QName)Candidate.QNAME, (String)"name");
    static final QName ENTITY_ID_QNAME = QName.create((QName)ENTITY_QNAME, (String)"id");
    static final QName ENTITY_OWNER_QNAME = QName.create((QName)ENTITY_QNAME, (String)"owner");
    static final QName ENTITY_TYPE_QNAME = QName.create((QName)EntityType.QNAME, (String)"type");
    static final YangInstanceIdentifier.NodeIdentifier ENTITY_OWNERS_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(EntityOwners.QNAME);
    static final YangInstanceIdentifier.NodeIdentifier ENTITY_OWNER_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(ENTITY_OWNER_QNAME);
    static final YangInstanceIdentifier.NodeIdentifier ENTITY_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(ENTITY_QNAME);
    static final YangInstanceIdentifier.NodeIdentifier ENTITY_ID_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(ENTITY_ID_QNAME);
    static final YangInstanceIdentifier.NodeIdentifier ENTITY_TYPE_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(ENTITY_TYPE_QNAME);
    static final YangInstanceIdentifier.NodeIdentifier CANDIDATE_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(Candidate.QNAME);
    static final YangInstanceIdentifier.NodeIdentifier CANDIDATE_NAME_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(CANDIDATE_NAME_QNAME);
    static final YangInstanceIdentifier ENTITY_OWNERS_PATH = YangInstanceIdentifier.of((QName)EntityOwners.QNAME);
    static final YangInstanceIdentifier ENTITY_TYPES_PATH = YangInstanceIdentifier.of((QName)EntityOwners.QNAME).node(EntityType.QNAME);
    private static final SharedSingletonMapTemplate<QName> NODE_KEY_TEMPLATE = SharedSingletonMapTemplate.ordered((Object)CANDIDATE_NAME_QNAME);

    private EntityOwnersModel() {
    }

    static YangInstanceIdentifier entityPath(String entityType, YangInstanceIdentifier entityId) {
        return YangInstanceIdentifier.builder((YangInstanceIdentifier)ENTITY_OWNERS_PATH).node(EntityType.QNAME).nodeWithKey(EntityType.QNAME, ENTITY_TYPE_QNAME, (Object)entityType).node(ENTITY_QNAME).nodeWithKey(ENTITY_QNAME, ENTITY_ID_QNAME, (Object)entityId).build();
    }

    static YangInstanceIdentifier candidatePath(String entityType, YangInstanceIdentifier entityId, String candidateName) {
        return YangInstanceIdentifier.builder((YangInstanceIdentifier)ENTITY_OWNERS_PATH).node(EntityType.QNAME).nodeWithKey(EntityType.QNAME, ENTITY_TYPE_QNAME, (Object)entityType).node(ENTITY_QNAME).nodeWithKey(ENTITY_QNAME, ENTITY_ID_QNAME, (Object)entityId).node(Candidate.QNAME).nodeWithKey(Candidate.QNAME, CANDIDATE_NAME_QNAME, (Object)candidateName).build();
    }

    static YangInstanceIdentifier candidatePath(YangInstanceIdentifier entityPath, String candidateName) {
        return YangInstanceIdentifier.builder((YangInstanceIdentifier)entityPath).node(Candidate.QNAME).nodeWithKey(Candidate.QNAME, CANDIDATE_NAME_QNAME, (Object)candidateName).build();
    }

    static YangInstanceIdentifier.NodeIdentifierWithPredicates candidateNodeKey(String candidateName) {
        return new YangInstanceIdentifier.NodeIdentifierWithPredicates(Candidate.QNAME, NODE_KEY_TEMPLATE.instantiateWithValue((Object)candidateName));
    }

    static NormalizedNode<?, ?> entityOwnersWithCandidate(String entityType, YangInstanceIdentifier entityId, String candidateName) {
        return EntityOwnersModel.entityOwnersWithEntityTypeEntry(EntityOwnersModel.entityTypeEntryWithEntityEntry(entityType, EntityOwnersModel.entityEntryWithCandidateEntry(entityId, candidateName)));
    }

    static ContainerNode entityOwnersWithEntityTypeEntry(MapEntryNode entityTypeNode) {
        return (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)ENTITY_OWNERS_NODE_ID).addChild(ImmutableNodes.mapNodeBuilder((QName)EntityType.QNAME).addChild((NormalizedNode)entityTypeNode).build()).build();
    }

    static MapEntryNode entityTypeEntryWithEntityEntry(String entityType, MapEntryNode entityNode) {
        return (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)EntityType.QNAME, (QName)ENTITY_TYPE_QNAME, (Object)entityType).addChild(ImmutableNodes.mapNodeBuilder((QName)ENTITY_QNAME).addChild((NormalizedNode)entityNode).build()).build();
    }

    static MapEntryNode entityEntryWithCandidateEntry(YangInstanceIdentifier entityId, String candidateName) {
        return (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)ENTITY_QNAME, (QName)ENTITY_ID_QNAME, (Object)entityId).addChild((NormalizedNode)EntityOwnersModel.candidateEntry(candidateName)).build();
    }

    static MapNode candidateEntry(String candidateName) {
        return (MapNode)ImmutableOrderedMapNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(Candidate.QNAME)).addChild((NormalizedNode)EntityOwnersModel.candidateMapEntry(candidateName)).build();
    }

    static MapEntryNode candidateMapEntry(String candidateName) {
        return ImmutableNodes.mapEntry((QName)Candidate.QNAME, (QName)CANDIDATE_NAME_QNAME, (Object)candidateName);
    }

    static MapEntryNode entityEntryWithOwner(YangInstanceIdentifier entityId, String owner) {
        return (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)ENTITY_QNAME, (QName)ENTITY_ID_QNAME, (Object)entityId).addChild((NormalizedNode)ImmutableNodes.leafNode((QName)ENTITY_OWNER_QNAME, (Object)(owner != null ? owner : ""))).build();
    }

    public static String entityTypeFromEntityPath(YangInstanceIdentifier entityPath) {
        YangInstanceIdentifier parent = entityPath;
        while (!parent.isEmpty()) {
            if (EntityType.QNAME.equals((Object)parent.getLastPathArgument().getNodeType())) {
                YangInstanceIdentifier.NodeIdentifierWithPredicates entityTypeLastPathArgument = (YangInstanceIdentifier.NodeIdentifierWithPredicates)parent.getLastPathArgument();
                return (String)entityTypeLastPathArgument.getKeyValues().get(ENTITY_TYPE_QNAME);
            }
            parent = parent.getParent();
        }
        return null;
    }

    static DOMEntity createEntity(YangInstanceIdentifier entityPath) {
        String entityType = null;
        YangInstanceIdentifier entityId = null;
        for (YangInstanceIdentifier.PathArgument pathArg : entityPath.getPathArguments()) {
            if (!(pathArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates)) continue;
            YangInstanceIdentifier.NodeIdentifierWithPredicates nodeKey = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArg;
            Map.Entry key = nodeKey.getKeyValues().entrySet().iterator().next();
            if (ENTITY_TYPE_QNAME.equals(key.getKey())) {
                entityType = key.getValue().toString();
                continue;
            }
            if (!ENTITY_ID_QNAME.equals(key.getKey())) continue;
            entityId = (YangInstanceIdentifier)key.getValue();
        }
        return new DOMEntity(entityType, entityId);
    }
}

