/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.datastore.entityownership.DistributedEntityOwnershipService;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListenerRegistration;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;

class DistributedEntityOwnershipListenerRegistration
extends AbstractObjectRegistration<DOMEntityOwnershipListener>
implements DOMEntityOwnershipListenerRegistration {
    private final DistributedEntityOwnershipService service;
    private final String entityType;

    DistributedEntityOwnershipListenerRegistration(DOMEntityOwnershipListener listener, String entityType, DistributedEntityOwnershipService service) {
        super((Object)listener);
        this.entityType = (String)Preconditions.checkNotNull((Object)entityType, (Object)"entityType cannot be null");
        this.service = (DistributedEntityOwnershipService)Preconditions.checkNotNull((Object)service, (Object)"DOMEntityOwnershipListener cannot be null");
    }

    protected void removeRegistration() {
        this.service.unregisterListener(this.getEntityType(), (DOMEntityOwnershipListener)this.getInstance());
    }

    public String getEntityType() {
        return this.entityType;
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("entityType", (Object)this.entityType);
    }
}

