/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.ShardConfig;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;

public final class ModuleConfig {
    private final String name;
    private final String namespace;
    private final ShardStrategy shardStrategy;
    private final Map<String, ShardConfig> shardConfigs;

    ModuleConfig(String name, String namespace, ShardStrategy shardStrategy, Map<String, ShardConfig> shardConfigs) {
        this.name = name;
        this.namespace = namespace;
        this.shardStrategy = shardStrategy;
        this.shardConfigs = shardConfigs;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public ShardStrategy getShardStrategy() {
        return this.shardStrategy;
    }

    @Nullable
    public ShardConfig getShardConfig(String forName) {
        return this.shardConfigs.get(forName);
    }

    @Nonnull
    public Collection<ShardConfig> getShardConfigs() {
        return this.shardConfigs.values();
    }

    @Nonnull
    public Collection<String> getShardNames() {
        return this.shardConfigs.keySet();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(ModuleConfig moduleConfig) {
        return new Builder(moduleConfig);
    }

    public static final class Builder {
        private String name;
        private String nameSpace;
        private ShardStrategy shardStrategy;
        private final Map<String, ShardConfig> shardConfigs = new HashMap<String, ShardConfig>();

        Builder(String name) {
            this.name = name;
        }

        private Builder(ModuleConfig moduleConfig) {
            this.name = moduleConfig.getName();
            this.nameSpace = moduleConfig.getNamespace();
            this.shardStrategy = moduleConfig.getShardStrategy();
            for (ShardConfig shardConfig : moduleConfig.getShardConfigs()) {
                this.shardConfigs.put(shardConfig.getName(), shardConfig);
            }
        }

        public Builder name(String newName) {
            this.name = newName;
            return this;
        }

        public Builder nameSpace(String newNameSpace) {
            this.nameSpace = newNameSpace;
            return this;
        }

        public Builder shardStrategy(ShardStrategy newShardStrategy) {
            this.shardStrategy = newShardStrategy;
            return this;
        }

        public Builder shardConfig(String shardName, Collection<MemberName> replicas) {
            this.shardConfigs.put(shardName, new ShardConfig(shardName, replicas));
            return this;
        }

        public ModuleConfig build() {
            return new ModuleConfig((String)Preconditions.checkNotNull((Object)this.name), this.nameSpace, this.shardStrategy, (Map<String, ShardConfig>)ImmutableMap.copyOf(this.shardConfigs));
        }
    }
}

