/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.SortedSet;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ChainedCommitCohort;
import org.opendaylight.controller.cluster.datastore.ReadOnlyShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionParent;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class ShardDataTreeTransactionChain
extends ShardDataTreeTransactionParent
implements Identifiable<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(ShardDataTreeTransactionChain.class);
    private final LocalHistoryIdentifier chainId;
    private final ShardDataTree dataTree;
    private ReadWriteShardDataTreeTransaction previousTx;
    private ReadWriteShardDataTreeTransaction openTransaction;
    private boolean closed;

    ShardDataTreeTransactionChain(LocalHistoryIdentifier localHistoryIdentifier, ShardDataTree dataTree) {
        this.chainId = (LocalHistoryIdentifier)Preconditions.checkNotNull((Object)localHistoryIdentifier);
        this.dataTree = (ShardDataTree)Preconditions.checkNotNull((Object)dataTree);
    }

    private DataTreeSnapshot getSnapshot() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"TransactionChain %s has been closed", (Object)this);
        Preconditions.checkState((this.openTransaction == null ? 1 : 0) != 0, (String)"Transaction %s is open", (Object)this.openTransaction);
        if (this.previousTx == null) {
            LOG.debug("Opening an unchained snapshot in {}", (Object)this.chainId);
            return this.dataTree.takeSnapshot();
        }
        LOG.debug("Reusing a chained snapshot in {}", (Object)this.chainId);
        return this.previousTx.getSnapshot();
    }

    ReadOnlyShardDataTreeTransaction newReadOnlyTransaction(TransactionIdentifier txId) {
        DataTreeSnapshot snapshot = this.getSnapshot();
        LOG.debug("Allocated read-only transaction {} snapshot {}", (Object)txId, (Object)snapshot);
        return new ReadOnlyShardDataTreeTransaction((ShardDataTreeTransactionParent)this, txId, snapshot);
    }

    ReadWriteShardDataTreeTransaction newReadWriteTransaction(TransactionIdentifier txId) {
        DataTreeSnapshot snapshot = this.getSnapshot();
        LOG.debug("Allocated read-write transaction {} snapshot {}", (Object)txId, (Object)snapshot);
        this.openTransaction = new ReadWriteShardDataTreeTransaction((ShardDataTreeTransactionParent)this, txId, snapshot.newModification());
        return this.openTransaction;
    }

    void close() {
        this.closed = true;
        LOG.debug("Closing chain {}", (Object)this.chainId);
    }

    @Override
    void abortFromTransactionActor(AbstractShardDataTreeTransaction<?> transaction) {
        if (transaction instanceof ReadWriteShardDataTreeTransaction) {
            Preconditions.checkState((this.openTransaction != null ? 1 : 0) != 0, (String)"Attempted to abort transaction %s while none is outstanding", transaction);
            LOG.debug("Aborted open transaction {}", transaction);
            this.openTransaction = null;
        }
    }

    @Override
    void abortTransaction(AbstractShardDataTreeTransaction<?> transaction, Runnable callback) {
        this.abortFromTransactionActor(transaction);
        this.dataTree.abortTransaction(transaction, callback);
    }

    @Override
    ShardDataTreeCohort finishTransaction(ReadWriteShardDataTreeTransaction transaction, Optional<SortedSet<String>> participatingShardNames) {
        Preconditions.checkState((this.openTransaction != null ? 1 : 0) != 0, (String)"Attempted to finish transaction %s while none is outstanding", (Object)transaction);
        ShardDataTreeCohort delegate = this.dataTree.finishTransaction(transaction, participatingShardNames);
        this.openTransaction = null;
        this.previousTx = transaction;
        LOG.debug("Committing transaction {}", (Object)transaction);
        return new ChainedCommitCohort(this, transaction, delegate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.chainId).toString();
    }

    void clearTransaction(ReadWriteShardDataTreeTransaction transaction) {
        if (transaction.equals(this.previousTx)) {
            this.previousTx = null;
        }
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.chainId;
    }

    @Override
    ShardDataTreeCohort createFailedCohort(TransactionIdentifier txId, DataTreeModification mod, Exception failure) {
        return this.dataTree.createFailedCohort(txId, mod, failure);
    }

    @Override
    ShardDataTreeCohort createReadyCohort(TransactionIdentifier txId, DataTreeModification mod, Optional<SortedSet<String>> participatingShardNames) {
        return this.dataTree.createReadyCohort(txId, mod, participatingShardNames);
    }
}

