/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Verify;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshotMetadata;

abstract class ShardDataTreeMetadata<T extends ShardDataTreeSnapshotMetadata<T>> {
    ShardDataTreeMetadata() {
    }

    final void applySnapshot(@Nonnull ShardDataTreeSnapshotMetadata<?> snapshot) {
        Verify.verify((boolean)this.getSupportedType().isInstance(snapshot), (String)"Snapshot %s misrouted to handler of %s", snapshot, this.getSupportedType());
        this.doApplySnapshot((ShardDataTreeSnapshotMetadata)this.getSupportedType().cast(snapshot));
    }

    abstract void reset();

    abstract void doApplySnapshot(@Nonnull T var1);

    @Nonnull
    abstract Class<T> getSupportedType();

    @Nullable
    abstract T toSnapshot();

    abstract void onTransactionAborted(TransactionIdentifier var1);

    abstract void onTransactionCommitted(TransactionIdentifier var1);

    abstract void onTransactionPurged(TransactionIdentifier var1);

    abstract void onHistoryCreated(LocalHistoryIdentifier var1);

    abstract void onHistoryClosed(LocalHistoryIdentifier var1);

    abstract void onHistoryPurged(LocalHistoryIdentifier var1);
}

