/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.Props;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.datastore.DefaultShardDataTreeChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeNotificationPublisherActor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

public final class ShardDataTreeChangePublisherActor
extends ShardDataTreeNotificationPublisherActor<DefaultShardDataTreeChangeListenerPublisher> {
    private ShardDataTreeChangePublisherActor(String name, String logContext) {
        super(new DefaultShardDataTreeChangeListenerPublisher(logContext), name, logContext);
    }

    @Override
    protected void handleReceive(Object message) {
        if (message instanceof RegisterListener) {
            RegisterListener reg = (RegisterListener)message;
            this.LOG.debug("{}: Received {}", (Object)this.logContext(), (Object)reg);
            if (reg.initialState.isPresent()) {
                DefaultShardDataTreeChangeListenerPublisher.notifySingleListener(reg.path, reg.listener, (DataTreeCandidate)reg.initialState.get(), this.logContext());
            } else {
                reg.listener.onInitialData();
            }
            ((DefaultShardDataTreeChangeListenerPublisher)this.publisher()).registerTreeChangeListener(reg.path, reg.listener, reg.onRegistration);
        } else {
            super.handleReceive(message);
        }
    }

    static Props props(String name, String logContext) {
        return Props.create(ShardDataTreeChangePublisherActor.class, (Object[])new Object[]{name, logContext});
    }

    static class RegisterListener {
        private final YangInstanceIdentifier path;
        private final DOMDataTreeChangeListener listener;
        private final Optional<DataTreeCandidate> initialState;
        private final Consumer<ListenerRegistration<DOMDataTreeChangeListener>> onRegistration;

        RegisterListener(YangInstanceIdentifier path, DOMDataTreeChangeListener listener, Optional<DataTreeCandidate> initialState, Consumer<ListenerRegistration<DOMDataTreeChangeListener>> onRegistration) {
            this.path = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)path);
            this.listener = (DOMDataTreeChangeListener)Preconditions.checkNotNull((Object)listener);
            this.initialState = (Optional)Preconditions.checkNotNull(initialState);
            this.onRegistration = (Consumer)Preconditions.checkNotNull(onRegistration);
        }

        public String toString() {
            return "RegisterListener [path=" + this.path + ", listener=" + this.listener + ", initialState present=" + this.initialState.isPresent() + "]";
        }
    }
}

