/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Props;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.datastore.Shard;

abstract class LeaderLocalDelegateFactory<M> {
    private final Shard shard;

    protected LeaderLocalDelegateFactory(Shard shard) {
        this.shard = (Shard)((Object)Preconditions.checkNotNull((Object)((Object)shard)));
    }

    protected final ActorRef getSelf() {
        return this.shard.getSelf();
    }

    protected final Shard getShard() {
        return this.shard;
    }

    protected final String persistenceId() {
        return this.shard.persistenceId();
    }

    protected final void tellSender(Object message) {
        this.shard.getSender().tell(message, this.getSelf());
    }

    protected final ActorRef createActor(Props props) {
        return this.shard.getContext().actorOf(props);
    }

    protected final ActorSelection selectActor(ActorRef ref) {
        return this.shard.getContext().system().actorSelection(ref.path());
    }

    protected final ActorSelection selectActor(ActorPath path) {
        return this.shard.getContext().system().actorSelection(path);
    }

    abstract void onLeadershipChange(boolean var1, boolean var2);

    abstract void onMessage(M var1, boolean var2, boolean var3);
}

