/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Optional;
import java.util.SortedSet;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionChain;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChainedCommitCohort
extends ShardDataTreeCohort {
    private static final Logger LOG = LoggerFactory.getLogger(ChainedCommitCohort.class);
    private final ReadWriteShardDataTreeTransaction transaction;
    private final ShardDataTreeTransactionChain chain;
    private final ShardDataTreeCohort delegate;

    ChainedCommitCohort(ShardDataTreeTransactionChain chain, ReadWriteShardDataTreeTransaction transaction, ShardDataTreeCohort delegate) {
        this.transaction = (ReadWriteShardDataTreeTransaction)Preconditions.checkNotNull((Object)transaction);
        this.delegate = (ShardDataTreeCohort)Preconditions.checkNotNull((Object)delegate);
        this.chain = (ShardDataTreeTransactionChain)Preconditions.checkNotNull((Object)chain);
    }

    @Override
    public void commit(final FutureCallback<UnsignedLong> callback) {
        this.delegate.commit(new FutureCallback<UnsignedLong>(){

            public void onSuccess(UnsignedLong result) {
                ChainedCommitCohort.this.chain.clearTransaction(ChainedCommitCohort.this.transaction);
                LOG.debug("Committed transaction {}", (Object)ChainedCommitCohort.this.transaction);
                callback.onSuccess((Object)result);
            }

            public void onFailure(Throwable failure) {
                LOG.error("Transaction {} commit failed, cannot recover", (Object)ChainedCommitCohort.this.transaction, (Object)failure);
                callback.onFailure(failure);
            }
        });
    }

    public TransactionIdentifier getIdentifier() {
        return (TransactionIdentifier)this.delegate.getIdentifier();
    }

    @Override
    public void canCommit(FutureCallback<Void> callback) {
        this.delegate.canCommit(callback);
    }

    @Override
    public void preCommit(FutureCallback<DataTreeCandidate> callback) {
        this.delegate.preCommit(callback);
    }

    @Override
    public void abort(FutureCallback<Void> callback) {
        this.delegate.abort(callback);
    }

    @Override
    DataTreeCandidateTip getCandidate() {
        return this.delegate.getCandidate();
    }

    @Override
    DataTreeModification getDataTreeModification() {
        return this.delegate.getDataTreeModification();
    }

    @Override
    public boolean isFailed() {
        return this.delegate.isFailed();
    }

    @Override
    public ShardDataTreeCohort.State getState() {
        return this.delegate.getState();
    }

    @Override
    Optional<SortedSet<String>> getParticipatingShardNames() {
        return this.delegate.getParticipatingShardNames();
    }
}

