/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.OnComplete;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.LocalTransactionContext;
import org.opendaylight.controller.cluster.datastore.LocalTransactionFactory;
import org.opendaylight.controller.cluster.datastore.NoOpTransactionContext;
import org.opendaylight.controller.cluster.datastore.RemoteTransactionContextSupport;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionContextWrapper;
import org.opendaylight.controller.cluster.datastore.TransactionProxy;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;
import scala.util.Try;

abstract class AbstractTransactionContextFactory<F extends LocalTransactionFactory>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransactionContextFactory.class);
    private static final AtomicLongFieldUpdater<AbstractTransactionContextFactory> TX_COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractTransactionContextFactory.class, "nextTx");
    private final ConcurrentMap<String, F> knownLocal = new ConcurrentHashMap<String, F>();
    private final LocalHistoryIdentifier historyId;
    private final ActorContext actorContext;
    private volatile long nextTx;

    protected AbstractTransactionContextFactory(ActorContext actorContext, LocalHistoryIdentifier historyId) {
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext);
        this.historyId = (LocalHistoryIdentifier)Preconditions.checkNotNull((Object)historyId);
    }

    final ActorContext getActorContext() {
        return this.actorContext;
    }

    final LocalHistoryIdentifier getHistoryId() {
        return this.historyId;
    }

    private TransactionContext maybeCreateLocalTransactionContext(TransactionProxy parent, String shardName) {
        LocalTransactionFactory local = (LocalTransactionFactory)this.knownLocal.get(shardName);
        if (local != null) {
            LOG.debug("Tx {} - Creating local component for shard {} using factory {}", new Object[]{parent.getIdentifier(), shardName, local});
            try {
                return AbstractTransactionContextFactory.createLocalTransactionContext(local, parent);
            }
            catch (Exception e) {
                return new NoOpTransactionContext(e, (TransactionIdentifier)parent.getIdentifier());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFindPrimaryShardSuccess(PrimaryShardInfo primaryShardInfo, TransactionProxy parent, String shardName, TransactionContextWrapper transactionContextWrapper) {
        LOG.debug("Tx {}: Found primary {} for shard {}", new Object[]{parent.getIdentifier(), primaryShardInfo.getPrimaryShardActor(), shardName});
        this.updateShardInfo(shardName, primaryShardInfo);
        try {
            TransactionContext localContext = this.maybeCreateLocalTransactionContext(parent, shardName);
            if (localContext != null) {
                transactionContextWrapper.executePriorTransactionOperations(localContext);
            } else {
                RemoteTransactionContextSupport remote = new RemoteTransactionContextSupport(transactionContextWrapper, parent, shardName);
                remote.setPrimaryShard(primaryShardInfo);
            }
        }
        finally {
            this.onTransactionContextCreated((TransactionIdentifier)parent.getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFindPrimaryShardFailure(Throwable failure, TransactionProxy parent, String shardName, TransactionContextWrapper transactionContextWrapper) {
        LOG.debug("Tx {}: Find primary for shard {} failed", new Object[]{parent.getIdentifier(), shardName, failure});
        try {
            transactionContextWrapper.executePriorTransactionOperations(new NoOpTransactionContext(failure, (TransactionIdentifier)parent.getIdentifier()));
        }
        finally {
            this.onTransactionContextCreated((TransactionIdentifier)parent.getIdentifier());
        }
    }

    final TransactionContextWrapper newTransactionContextWrapper(final TransactionProxy parent, final String shardName) {
        final TransactionContextWrapper transactionContextWrapper = new TransactionContextWrapper((TransactionIdentifier)parent.getIdentifier(), this.actorContext, shardName);
        Future<PrimaryShardInfo> findPrimaryFuture = this.findPrimaryShard(shardName, (TransactionIdentifier)parent.getIdentifier());
        if (findPrimaryFuture.isCompleted()) {
            Try maybe = (Try)findPrimaryFuture.value().get();
            if (maybe.isSuccess()) {
                this.onFindPrimaryShardSuccess((PrimaryShardInfo)maybe.get(), parent, shardName, transactionContextWrapper);
            } else {
                this.onFindPrimaryShardFailure((Throwable)maybe.failed().get(), parent, shardName, transactionContextWrapper);
            }
        } else {
            findPrimaryFuture.onComplete((Function1)new OnComplete<PrimaryShardInfo>(){

                public void onComplete(Throwable failure, PrimaryShardInfo primaryShardInfo) {
                    if (failure == null) {
                        AbstractTransactionContextFactory.this.onFindPrimaryShardSuccess(primaryShardInfo, parent, shardName, transactionContextWrapper);
                    } else {
                        AbstractTransactionContextFactory.this.onFindPrimaryShardFailure(failure, parent, shardName, transactionContextWrapper);
                    }
                }
            }, this.actorContext.getClientDispatcher());
        }
        return transactionContextWrapper;
    }

    private void updateShardInfo(String shardName, PrimaryShardInfo primaryShardInfo) {
        Optional<DataTree> maybeDataTree = primaryShardInfo.getLocalShardDataTree();
        if (maybeDataTree.isPresent()) {
            if (!this.knownLocal.containsKey(shardName)) {
                LOG.debug("Shard {} resolved to local data tree - adding local factory", (Object)shardName);
                F factory = this.factoryForShard(shardName, primaryShardInfo.getPrimaryShardActor(), maybeDataTree.get());
                this.knownLocal.putIfAbsent(shardName, factory);
            }
        } else if (this.knownLocal.containsKey(shardName)) {
            LOG.debug("Shard {} invalidating local data tree", (Object)shardName);
            this.knownLocal.remove(shardName);
        }
    }

    protected final MemberName getMemberName() {
        return this.historyId.getClientId().getFrontendId().getMemberName();
    }

    protected final TransactionIdentifier nextIdentifier() {
        return new TransactionIdentifier(this.historyId, TX_COUNTER_UPDATER.getAndIncrement(this));
    }

    protected abstract Future<PrimaryShardInfo> findPrimaryShard(@Nonnull String var1, @Nonnull TransactionIdentifier var2);

    protected abstract F factoryForShard(String var1, ActorSelection var2, DataTree var3);

    protected abstract <T> void onTransactionReady(@Nonnull TransactionIdentifier var1, @Nonnull Collection<Future<T>> var2);

    protected abstract void onTransactionContextCreated(@Nonnull TransactionIdentifier var1);

    private static TransactionContext createLocalTransactionContext(LocalTransactionFactory factory, TransactionProxy parent) {
        switch (parent.getType()) {
            case READ_ONLY: {
                final DOMStoreReadTransaction readOnly = factory.newReadOnlyTransaction((TransactionIdentifier)parent.getIdentifier());
                return new LocalTransactionContext((DOMStoreTransaction)readOnly, (TransactionIdentifier)parent.getIdentifier(), factory){

                    @Override
                    protected DOMStoreWriteTransaction getWriteDelegate() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    protected DOMStoreReadTransaction getReadDelegate() {
                        return readOnly;
                    }
                };
            }
            case READ_WRITE: {
                final DOMStoreReadWriteTransaction readWrite = factory.newReadWriteTransaction((TransactionIdentifier)parent.getIdentifier());
                return new LocalTransactionContext((DOMStoreTransaction)readWrite, (TransactionIdentifier)parent.getIdentifier(), factory){

                    @Override
                    protected DOMStoreWriteTransaction getWriteDelegate() {
                        return readWrite;
                    }

                    @Override
                    protected DOMStoreReadTransaction getReadDelegate() {
                        return readWrite;
                    }
                };
            }
            case WRITE_ONLY: {
                final DOMStoreWriteTransaction writeOnly = factory.newWriteOnlyTransaction((TransactionIdentifier)parent.getIdentifier());
                return new LocalTransactionContext((DOMStoreTransaction)writeOnly, (TransactionIdentifier)parent.getIdentifier(), factory){

                    @Override
                    protected DOMStoreWriteTransaction getWriteDelegate() {
                        return writeOnly;
                    }

                    @Override
                    protected DOMStoreReadTransaction getReadDelegate() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
        throw new IllegalArgumentException("Invalid transaction type: " + (Object)((Object)parent.getType()));
    }
}

