/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SingleClientHistory
extends AbstractClientHistory {
    private static final Logger LOG = LoggerFactory.getLogger(SingleClientHistory.class);

    SingleClientHistory(AbstractDataStoreClientBehavior client, LocalHistoryIdentifier identifier) {
        super(client, identifier);
    }

    @Override
    ClientSnapshot doCreateSnapshot() {
        TransactionIdentifier txId = new TransactionIdentifier(this.getIdentifier(), this.nextTx());
        LOG.debug("{}: creating a new snapshot {}", (Object)this, (Object)txId);
        return new ClientSnapshot(this, txId);
    }

    @Override
    ClientTransaction doCreateTransaction() {
        TransactionIdentifier txId = new TransactionIdentifier(this.getIdentifier(), this.nextTx());
        LOG.debug("{}: creating a new transaction {}", (Object)this, (Object)txId);
        return new ClientTransaction(this, txId);
    }

    @Override
    ProxyHistory createHistoryProxy(LocalHistoryIdentifier historyId, AbstractClientConnection<ShardBackendInfo> connection) {
        return ProxyHistory.createSingle(this, connection, historyId);
    }
}

