/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.client.ReconnectForwarder;
import org.opendaylight.controller.cluster.access.commands.LocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.HistoryReconnectCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyReconnectCohort;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BouncingReconnectForwarder
extends ReconnectForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(BouncingReconnectForwarder.class);
    private final Map<LocalHistoryIdentifier, ProxyReconnectCohort> cohorts;

    private BouncingReconnectForwarder(ConnectedClientConnection<?> successor, Map<LocalHistoryIdentifier, ProxyReconnectCohort> cohorts) {
        super(successor);
        this.cohorts = (Map)Preconditions.checkNotNull(cohorts);
    }

    static ReconnectForwarder forCohorts(ConnectedClientConnection<?> successor, Collection<HistoryReconnectCohort> cohorts) {
        return new BouncingReconnectForwarder(successor, (Map<LocalHistoryIdentifier, ProxyReconnectCohort>)Maps.uniqueIndex((Iterable)Collections2.transform(cohorts, HistoryReconnectCohort::getProxy), Identifiable::getIdentifier));
    }

    protected void forwardEntry(ConnectionEntry entry, long now) {
        try {
            this.findCohort(entry).forwardEntry(entry, arg_0 -> ((BouncingReconnectForwarder)this).sendToSuccessor(arg_0));
        }
        catch (RequestException e) {
            entry.complete((Response)entry.getRequest().toRequestFailure(e));
        }
    }

    protected void replayEntry(ConnectionEntry entry, long now) {
        try {
            this.findCohort(entry).replayEntry(entry, arg_0 -> ((BouncingReconnectForwarder)this).replayToSuccessor(arg_0));
        }
        catch (RequestException e) {
            entry.complete((Response)entry.getRequest().toRequestFailure(e));
        }
    }

    private ProxyReconnectCohort findCohort(ConnectionEntry entry) throws CohortNotFoundException {
        LocalHistoryIdentifier historyId;
        Request request = entry.getRequest();
        if (request instanceof TransactionRequest) {
            historyId = ((TransactionIdentifier)((TransactionRequest)request).getTarget()).getHistoryId();
        } else if (request instanceof LocalHistoryRequest) {
            historyId = (LocalHistoryIdentifier)((LocalHistoryRequest)request).getTarget();
        } else {
            throw new IllegalArgumentException("Unhandled request " + request);
        }
        ProxyReconnectCohort cohort = this.cohorts.get(historyId);
        if (cohort == null) {
            LOG.warn("Cohort for request {} not found, aborting it", (Object)request);
            throw new CohortNotFoundException(historyId);
        }
        return cohort;
    }

    private static final class CohortNotFoundException
    extends RequestException {
        private static final long serialVersionUID = 1L;

        CohortNotFoundException(LocalHistoryIdentifier historyId) {
            super("Cohort for " + historyId + " not found");
        }

        public boolean isRetriable() {
            return false;
        }
    }
}

