/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.protocol.Specification;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ProtocolBuilder
implements Builder<Protocol> {
    private Protocol.Name _name;
    private Specification _specification;
    Map<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>> augmentation = Collections.emptyMap();

    public ProtocolBuilder() {
    }

    public ProtocolBuilder(Protocol base) {
        Map aug;
        this._name = base.getName();
        this._specification = base.getSpecification();
        if (base instanceof ProtocolImpl) {
            ProtocolImpl impl = (ProtocolImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>>(aug);
        }
    }

    public Protocol.Name getName() {
        return this._name;
    }

    public Specification getSpecification() {
        return this._specification;
    }

    public <E$$ extends Augmentation<Protocol>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ProtocolBuilder setName(Protocol.Name value) {
        this._name = value;
        return this;
    }

    public ProtocolBuilder setSpecification(Specification value) {
        this._specification = value;
        return this;
    }

    public ProtocolBuilder addAugmentation(Class<? extends Augmentation<Protocol>> augmentationType, Augmentation<Protocol> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ProtocolBuilder removeAugmentation(Class<? extends Augmentation<Protocol>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Protocol build() {
        return new ProtocolImpl(this);
    }

    private static final class ProtocolImpl
    implements Protocol {
        private final Protocol.Name _name;
        private final Specification _specification;
        private Map<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ProtocolImpl(ProtocolBuilder base) {
            this._name = base.getName();
            this._specification = base.getSpecification();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Protocol> getImplementedInterface() {
            return Protocol.class;
        }

        @Override
        public Protocol.Name getName() {
            return this._name;
        }

        @Override
        public Specification getSpecification() {
            return this._specification;
        }

        public <E$$ extends Augmentation<Protocol>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._name);
            result = 31 * result + Objects.hashCode(this._specification);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Protocol.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Protocol other = (Protocol)obj;
            if (!Objects.equals((Object)this._name, (Object)other.getName())) {
                return false;
            }
            if (!Objects.equals(this._specification, other.getSpecification())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ProtocolImpl otherImpl = (ProtocolImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Protocol>>, Augmentation<Protocol>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Protocol");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)((Object)this._name));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_specification", (Object)this._specification);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

