/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.CreateDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeCredentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfSchemaStorage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.NonModuleCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.OdlHelloMessageCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.YangModuleCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.AvailableCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.ClusteredConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.PassThrough;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.UnavailableCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.schema.storage.YangLibrary;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CreateDeviceInputBuilder
implements Builder<CreateDeviceInput> {
    private Integer _actorResponseWaitTime;
    private AvailableCapabilities _availableCapabilities;
    private Integer _betweenAttemptsTimeoutMillis;
    private ClusteredConnectionStatus _clusteredConnectionStatus;
    private Integer _concurrentRpcLimit;
    private String _connectedMessage;
    private NetconfNodeConnectionStatus.ConnectionStatus _connectionStatus;
    private Long _connectionTimeoutMillis;
    private Credentials _credentials;
    private Long _defaultRequestTimeoutMillis;
    private Host _host;
    private Long _keepaliveDelay;
    private Long _maxConnectionAttempts;
    private String _nodeId;
    private NonModuleCapabilities _nonModuleCapabilities;
    private OdlHelloMessageCapabilities _odlHelloMessageCapabilities;
    private PassThrough _passThrough;
    private PortNumber _port;
    private Protocol _protocol;
    private String _schemaCacheDirectory;
    private BigDecimal _sleepFactor;
    private UnavailableCapabilities _unavailableCapabilities;
    private YangLibrary _yangLibrary;
    private YangModuleCapabilities _yangModuleCapabilities;
    private Boolean _reconnectOnChangedSchema;
    private Boolean _schemaless;
    private Boolean _tcpOnly;
    Map<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>> augmentation = Collections.emptyMap();

    public CreateDeviceInputBuilder() {
    }

    public CreateDeviceInputBuilder(NetconfNodeConnectionParameters arg) {
        this._host = arg.getHost();
        this._port = arg.getPort();
        this._tcpOnly = arg.isTcpOnly();
        this._protocol = arg.getProtocol();
        this._schemaless = arg.isSchemaless();
        this._yangModuleCapabilities = arg.getYangModuleCapabilities();
        this._nonModuleCapabilities = arg.getNonModuleCapabilities();
        this._reconnectOnChangedSchema = arg.isReconnectOnChangedSchema();
        this._connectionTimeoutMillis = arg.getConnectionTimeoutMillis();
        this._defaultRequestTimeoutMillis = arg.getDefaultRequestTimeoutMillis();
        this._maxConnectionAttempts = arg.getMaxConnectionAttempts();
        this._betweenAttemptsTimeoutMillis = arg.getBetweenAttemptsTimeoutMillis();
        this._sleepFactor = arg.getSleepFactor();
        this._keepaliveDelay = arg.getKeepaliveDelay();
        this._concurrentRpcLimit = arg.getConcurrentRpcLimit();
        this._actorResponseWaitTime = arg.getActorResponseWaitTime();
        this._odlHelloMessageCapabilities = arg.getOdlHelloMessageCapabilities();
    }

    public CreateDeviceInputBuilder(NetconfNodeCredentials arg) {
        this._credentials = arg.getCredentials();
    }

    public CreateDeviceInputBuilder(NetconfNodeConnectionStatus arg) {
        this._connectionStatus = arg.getConnectionStatus();
        this._clusteredConnectionStatus = arg.getClusteredConnectionStatus();
        this._connectedMessage = arg.getConnectedMessage();
        this._availableCapabilities = arg.getAvailableCapabilities();
        this._unavailableCapabilities = arg.getUnavailableCapabilities();
        this._passThrough = arg.getPassThrough();
    }

    public CreateDeviceInputBuilder(NetconfSchemaStorage arg) {
        this._schemaCacheDirectory = arg.getSchemaCacheDirectory();
        this._yangLibrary = arg.getYangLibrary();
    }

    public CreateDeviceInputBuilder(CreateDeviceInput base) {
        Map aug;
        this._actorResponseWaitTime = base.getActorResponseWaitTime();
        this._availableCapabilities = base.getAvailableCapabilities();
        this._betweenAttemptsTimeoutMillis = base.getBetweenAttemptsTimeoutMillis();
        this._clusteredConnectionStatus = base.getClusteredConnectionStatus();
        this._concurrentRpcLimit = base.getConcurrentRpcLimit();
        this._connectedMessage = base.getConnectedMessage();
        this._connectionStatus = base.getConnectionStatus();
        this._connectionTimeoutMillis = base.getConnectionTimeoutMillis();
        this._credentials = base.getCredentials();
        this._defaultRequestTimeoutMillis = base.getDefaultRequestTimeoutMillis();
        this._host = base.getHost();
        this._keepaliveDelay = base.getKeepaliveDelay();
        this._maxConnectionAttempts = base.getMaxConnectionAttempts();
        this._nodeId = base.getNodeId();
        this._nonModuleCapabilities = base.getNonModuleCapabilities();
        this._odlHelloMessageCapabilities = base.getOdlHelloMessageCapabilities();
        this._passThrough = base.getPassThrough();
        this._port = base.getPort();
        this._protocol = base.getProtocol();
        this._schemaCacheDirectory = base.getSchemaCacheDirectory();
        this._sleepFactor = base.getSleepFactor();
        this._unavailableCapabilities = base.getUnavailableCapabilities();
        this._yangLibrary = base.getYangLibrary();
        this._yangModuleCapabilities = base.getYangModuleCapabilities();
        this._reconnectOnChangedSchema = base.isReconnectOnChangedSchema();
        this._schemaless = base.isSchemaless();
        this._tcpOnly = base.isTcpOnly();
        if (base instanceof CreateDeviceInputImpl) {
            CreateDeviceInputImpl impl = (CreateDeviceInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NetconfNodeCredentials) {
            this._credentials = ((NetconfNodeCredentials)arg).getCredentials();
            isValidArg = true;
        }
        if (arg instanceof NetconfNodeConnectionStatus) {
            this._connectionStatus = ((NetconfNodeConnectionStatus)arg).getConnectionStatus();
            this._clusteredConnectionStatus = ((NetconfNodeConnectionStatus)arg).getClusteredConnectionStatus();
            this._connectedMessage = ((NetconfNodeConnectionStatus)arg).getConnectedMessage();
            this._availableCapabilities = ((NetconfNodeConnectionStatus)arg).getAvailableCapabilities();
            this._unavailableCapabilities = ((NetconfNodeConnectionStatus)arg).getUnavailableCapabilities();
            this._passThrough = ((NetconfNodeConnectionStatus)arg).getPassThrough();
            isValidArg = true;
        }
        if (arg instanceof NetconfSchemaStorage) {
            this._schemaCacheDirectory = ((NetconfSchemaStorage)arg).getSchemaCacheDirectory();
            this._yangLibrary = ((NetconfSchemaStorage)arg).getYangLibrary();
            isValidArg = true;
        }
        if (arg instanceof NetconfNodeConnectionParameters) {
            this._host = ((NetconfNodeConnectionParameters)arg).getHost();
            this._port = ((NetconfNodeConnectionParameters)arg).getPort();
            this._tcpOnly = ((NetconfNodeConnectionParameters)arg).isTcpOnly();
            this._protocol = ((NetconfNodeConnectionParameters)arg).getProtocol();
            this._schemaless = ((NetconfNodeConnectionParameters)arg).isSchemaless();
            this._yangModuleCapabilities = ((NetconfNodeConnectionParameters)arg).getYangModuleCapabilities();
            this._nonModuleCapabilities = ((NetconfNodeConnectionParameters)arg).getNonModuleCapabilities();
            this._reconnectOnChangedSchema = ((NetconfNodeConnectionParameters)arg).isReconnectOnChangedSchema();
            this._connectionTimeoutMillis = ((NetconfNodeConnectionParameters)arg).getConnectionTimeoutMillis();
            this._defaultRequestTimeoutMillis = ((NetconfNodeConnectionParameters)arg).getDefaultRequestTimeoutMillis();
            this._maxConnectionAttempts = ((NetconfNodeConnectionParameters)arg).getMaxConnectionAttempts();
            this._betweenAttemptsTimeoutMillis = ((NetconfNodeConnectionParameters)arg).getBetweenAttemptsTimeoutMillis();
            this._sleepFactor = ((NetconfNodeConnectionParameters)arg).getSleepFactor();
            this._keepaliveDelay = ((NetconfNodeConnectionParameters)arg).getKeepaliveDelay();
            this._concurrentRpcLimit = ((NetconfNodeConnectionParameters)arg).getConcurrentRpcLimit();
            this._actorResponseWaitTime = ((NetconfNodeConnectionParameters)arg).getActorResponseWaitTime();
            this._odlHelloMessageCapabilities = ((NetconfNodeConnectionParameters)arg).getOdlHelloMessageCapabilities();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeCredentials, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfSchemaStorage, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionParameters]");
    }

    public Integer getActorResponseWaitTime() {
        return this._actorResponseWaitTime;
    }

    public AvailableCapabilities getAvailableCapabilities() {
        return this._availableCapabilities;
    }

    public Integer getBetweenAttemptsTimeoutMillis() {
        return this._betweenAttemptsTimeoutMillis;
    }

    public ClusteredConnectionStatus getClusteredConnectionStatus() {
        return this._clusteredConnectionStatus;
    }

    public Integer getConcurrentRpcLimit() {
        return this._concurrentRpcLimit;
    }

    public String getConnectedMessage() {
        return this._connectedMessage;
    }

    public NetconfNodeConnectionStatus.ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public Long getConnectionTimeoutMillis() {
        return this._connectionTimeoutMillis;
    }

    public Credentials getCredentials() {
        return this._credentials;
    }

    public Long getDefaultRequestTimeoutMillis() {
        return this._defaultRequestTimeoutMillis;
    }

    public Host getHost() {
        return this._host;
    }

    public Long getKeepaliveDelay() {
        return this._keepaliveDelay;
    }

    public Long getMaxConnectionAttempts() {
        return this._maxConnectionAttempts;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public NonModuleCapabilities getNonModuleCapabilities() {
        return this._nonModuleCapabilities;
    }

    public OdlHelloMessageCapabilities getOdlHelloMessageCapabilities() {
        return this._odlHelloMessageCapabilities;
    }

    public PassThrough getPassThrough() {
        return this._passThrough;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Protocol getProtocol() {
        return this._protocol;
    }

    public String getSchemaCacheDirectory() {
        return this._schemaCacheDirectory;
    }

    public BigDecimal getSleepFactor() {
        return this._sleepFactor;
    }

    public UnavailableCapabilities getUnavailableCapabilities() {
        return this._unavailableCapabilities;
    }

    public YangLibrary getYangLibrary() {
        return this._yangLibrary;
    }

    public YangModuleCapabilities getYangModuleCapabilities() {
        return this._yangModuleCapabilities;
    }

    public Boolean isReconnectOnChangedSchema() {
        return this._reconnectOnChangedSchema;
    }

    public Boolean isSchemaless() {
        return this._schemaless;
    }

    public Boolean isTcpOnly() {
        return this._tcpOnly;
    }

    public <E$$ extends Augmentation<CreateDeviceInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkActorResponseWaitTimeRange(int value) {
        if (value >= 1 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..65535]]", (int)value);
    }

    public CreateDeviceInputBuilder setActorResponseWaitTime(Integer value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkActorResponseWaitTimeRange(value);
        }
        this._actorResponseWaitTime = value;
        return this;
    }

    public CreateDeviceInputBuilder setAvailableCapabilities(AvailableCapabilities value) {
        this._availableCapabilities = value;
        return this;
    }

    private static void checkBetweenAttemptsTimeoutMillisRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public CreateDeviceInputBuilder setBetweenAttemptsTimeoutMillis(Integer value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkBetweenAttemptsTimeoutMillisRange(value);
        }
        this._betweenAttemptsTimeoutMillis = value;
        return this;
    }

    public CreateDeviceInputBuilder setClusteredConnectionStatus(ClusteredConnectionStatus value) {
        this._clusteredConnectionStatus = value;
        return this;
    }

    private static void checkConcurrentRpcLimitRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public CreateDeviceInputBuilder setConcurrentRpcLimit(Integer value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkConcurrentRpcLimitRange(value);
        }
        this._concurrentRpcLimit = value;
        return this;
    }

    public CreateDeviceInputBuilder setConnectedMessage(String value) {
        this._connectedMessage = value;
        return this;
    }

    public CreateDeviceInputBuilder setConnectionStatus(NetconfNodeConnectionStatus.ConnectionStatus value) {
        this._connectionStatus = value;
        return this;
    }

    private static void checkConnectionTimeoutMillisRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public CreateDeviceInputBuilder setConnectionTimeoutMillis(Long value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkConnectionTimeoutMillisRange(value);
        }
        this._connectionTimeoutMillis = value;
        return this;
    }

    public CreateDeviceInputBuilder setCredentials(Credentials value) {
        this._credentials = value;
        return this;
    }

    private static void checkDefaultRequestTimeoutMillisRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public CreateDeviceInputBuilder setDefaultRequestTimeoutMillis(Long value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkDefaultRequestTimeoutMillisRange(value);
        }
        this._defaultRequestTimeoutMillis = value;
        return this;
    }

    public CreateDeviceInputBuilder setHost(Host value) {
        this._host = value;
        return this;
    }

    private static void checkKeepaliveDelayRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public CreateDeviceInputBuilder setKeepaliveDelay(Long value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkKeepaliveDelayRange(value);
        }
        this._keepaliveDelay = value;
        return this;
    }

    private static void checkMaxConnectionAttemptsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public CreateDeviceInputBuilder setMaxConnectionAttempts(Long value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkMaxConnectionAttemptsRange(value);
        }
        this._maxConnectionAttempts = value;
        return this;
    }

    public CreateDeviceInputBuilder setNodeId(String value) {
        this._nodeId = value;
        return this;
    }

    public CreateDeviceInputBuilder setNonModuleCapabilities(NonModuleCapabilities value) {
        this._nonModuleCapabilities = value;
        return this;
    }

    public CreateDeviceInputBuilder setOdlHelloMessageCapabilities(OdlHelloMessageCapabilities value) {
        this._odlHelloMessageCapabilities = value;
        return this;
    }

    public CreateDeviceInputBuilder setPassThrough(PassThrough value) {
        this._passThrough = value;
        return this;
    }

    public CreateDeviceInputBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public CreateDeviceInputBuilder setProtocol(Protocol value) {
        this._protocol = value;
        return this;
    }

    public CreateDeviceInputBuilder setSchemaCacheDirectory(String value) {
        this._schemaCacheDirectory = value;
        return this;
    }

    public CreateDeviceInputBuilder setSleepFactor(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._sleepFactor = value;
        return this;
    }

    public CreateDeviceInputBuilder setUnavailableCapabilities(UnavailableCapabilities value) {
        this._unavailableCapabilities = value;
        return this;
    }

    public CreateDeviceInputBuilder setYangLibrary(YangLibrary value) {
        this._yangLibrary = value;
        return this;
    }

    public CreateDeviceInputBuilder setYangModuleCapabilities(YangModuleCapabilities value) {
        this._yangModuleCapabilities = value;
        return this;
    }

    public CreateDeviceInputBuilder setReconnectOnChangedSchema(Boolean value) {
        this._reconnectOnChangedSchema = value;
        return this;
    }

    public CreateDeviceInputBuilder setSchemaless(Boolean value) {
        this._schemaless = value;
        return this;
    }

    public CreateDeviceInputBuilder setTcpOnly(Boolean value) {
        this._tcpOnly = value;
        return this;
    }

    public CreateDeviceInputBuilder addAugmentation(Class<? extends Augmentation<CreateDeviceInput>> augmentationType, Augmentation<CreateDeviceInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CreateDeviceInputBuilder removeAugmentation(Class<? extends Augmentation<CreateDeviceInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CreateDeviceInput build() {
        return new CreateDeviceInputImpl(this);
    }

    private static final class CreateDeviceInputImpl
    implements CreateDeviceInput {
        private final Integer _actorResponseWaitTime;
        private final AvailableCapabilities _availableCapabilities;
        private final Integer _betweenAttemptsTimeoutMillis;
        private final ClusteredConnectionStatus _clusteredConnectionStatus;
        private final Integer _concurrentRpcLimit;
        private final String _connectedMessage;
        private final NetconfNodeConnectionStatus.ConnectionStatus _connectionStatus;
        private final Long _connectionTimeoutMillis;
        private final Credentials _credentials;
        private final Long _defaultRequestTimeoutMillis;
        private final Host _host;
        private final Long _keepaliveDelay;
        private final Long _maxConnectionAttempts;
        private final String _nodeId;
        private final NonModuleCapabilities _nonModuleCapabilities;
        private final OdlHelloMessageCapabilities _odlHelloMessageCapabilities;
        private final PassThrough _passThrough;
        private final PortNumber _port;
        private final Protocol _protocol;
        private final String _schemaCacheDirectory;
        private final BigDecimal _sleepFactor;
        private final UnavailableCapabilities _unavailableCapabilities;
        private final YangLibrary _yangLibrary;
        private final YangModuleCapabilities _yangModuleCapabilities;
        private final Boolean _reconnectOnChangedSchema;
        private final Boolean _schemaless;
        private final Boolean _tcpOnly;
        private Map<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        CreateDeviceInputImpl(CreateDeviceInputBuilder base) {
            this._actorResponseWaitTime = base.getActorResponseWaitTime();
            this._availableCapabilities = base.getAvailableCapabilities();
            this._betweenAttemptsTimeoutMillis = base.getBetweenAttemptsTimeoutMillis();
            this._clusteredConnectionStatus = base.getClusteredConnectionStatus();
            this._concurrentRpcLimit = base.getConcurrentRpcLimit();
            this._connectedMessage = base.getConnectedMessage();
            this._connectionStatus = base.getConnectionStatus();
            this._connectionTimeoutMillis = base.getConnectionTimeoutMillis();
            this._credentials = base.getCredentials();
            this._defaultRequestTimeoutMillis = base.getDefaultRequestTimeoutMillis();
            this._host = base.getHost();
            this._keepaliveDelay = base.getKeepaliveDelay();
            this._maxConnectionAttempts = base.getMaxConnectionAttempts();
            this._nodeId = base.getNodeId();
            this._nonModuleCapabilities = base.getNonModuleCapabilities();
            this._odlHelloMessageCapabilities = base.getOdlHelloMessageCapabilities();
            this._passThrough = base.getPassThrough();
            this._port = base.getPort();
            this._protocol = base.getProtocol();
            this._schemaCacheDirectory = base.getSchemaCacheDirectory();
            this._sleepFactor = base.getSleepFactor();
            this._unavailableCapabilities = base.getUnavailableCapabilities();
            this._yangLibrary = base.getYangLibrary();
            this._yangModuleCapabilities = base.getYangModuleCapabilities();
            this._reconnectOnChangedSchema = base.isReconnectOnChangedSchema();
            this._schemaless = base.isSchemaless();
            this._tcpOnly = base.isTcpOnly();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<CreateDeviceInput> getImplementedInterface() {
            return CreateDeviceInput.class;
        }

        @Override
        public Integer getActorResponseWaitTime() {
            return this._actorResponseWaitTime;
        }

        @Override
        public AvailableCapabilities getAvailableCapabilities() {
            return this._availableCapabilities;
        }

        @Override
        public Integer getBetweenAttemptsTimeoutMillis() {
            return this._betweenAttemptsTimeoutMillis;
        }

        @Override
        public ClusteredConnectionStatus getClusteredConnectionStatus() {
            return this._clusteredConnectionStatus;
        }

        @Override
        public Integer getConcurrentRpcLimit() {
            return this._concurrentRpcLimit;
        }

        @Override
        public String getConnectedMessage() {
            return this._connectedMessage;
        }

        @Override
        public NetconfNodeConnectionStatus.ConnectionStatus getConnectionStatus() {
            return this._connectionStatus;
        }

        @Override
        public Long getConnectionTimeoutMillis() {
            return this._connectionTimeoutMillis;
        }

        @Override
        public Credentials getCredentials() {
            return this._credentials;
        }

        @Override
        public Long getDefaultRequestTimeoutMillis() {
            return this._defaultRequestTimeoutMillis;
        }

        @Override
        public Host getHost() {
            return this._host;
        }

        @Override
        public Long getKeepaliveDelay() {
            return this._keepaliveDelay;
        }

        @Override
        public Long getMaxConnectionAttempts() {
            return this._maxConnectionAttempts;
        }

        @Override
        public String getNodeId() {
            return this._nodeId;
        }

        @Override
        public NonModuleCapabilities getNonModuleCapabilities() {
            return this._nonModuleCapabilities;
        }

        @Override
        public OdlHelloMessageCapabilities getOdlHelloMessageCapabilities() {
            return this._odlHelloMessageCapabilities;
        }

        @Override
        public PassThrough getPassThrough() {
            return this._passThrough;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public Protocol getProtocol() {
            return this._protocol;
        }

        @Override
        public String getSchemaCacheDirectory() {
            return this._schemaCacheDirectory;
        }

        @Override
        public BigDecimal getSleepFactor() {
            return this._sleepFactor;
        }

        @Override
        public UnavailableCapabilities getUnavailableCapabilities() {
            return this._unavailableCapabilities;
        }

        @Override
        public YangLibrary getYangLibrary() {
            return this._yangLibrary;
        }

        @Override
        public YangModuleCapabilities getYangModuleCapabilities() {
            return this._yangModuleCapabilities;
        }

        @Override
        public Boolean isReconnectOnChangedSchema() {
            return this._reconnectOnChangedSchema;
        }

        @Override
        public Boolean isSchemaless() {
            return this._schemaless;
        }

        @Override
        public Boolean isTcpOnly() {
            return this._tcpOnly;
        }

        public <E$$ extends Augmentation<CreateDeviceInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._actorResponseWaitTime);
            result = 31 * result + Objects.hashCode(this._availableCapabilities);
            result = 31 * result + Objects.hashCode(this._betweenAttemptsTimeoutMillis);
            result = 31 * result + Objects.hashCode(this._clusteredConnectionStatus);
            result = 31 * result + Objects.hashCode(this._concurrentRpcLimit);
            result = 31 * result + Objects.hashCode(this._connectedMessage);
            result = 31 * result + Objects.hashCode((Object)this._connectionStatus);
            result = 31 * result + Objects.hashCode(this._connectionTimeoutMillis);
            result = 31 * result + Objects.hashCode(this._credentials);
            result = 31 * result + Objects.hashCode(this._defaultRequestTimeoutMillis);
            result = 31 * result + Objects.hashCode(this._host);
            result = 31 * result + Objects.hashCode(this._keepaliveDelay);
            result = 31 * result + Objects.hashCode(this._maxConnectionAttempts);
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._nonModuleCapabilities);
            result = 31 * result + Objects.hashCode(this._odlHelloMessageCapabilities);
            result = 31 * result + Objects.hashCode(this._passThrough);
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._protocol);
            result = 31 * result + Objects.hashCode(this._schemaCacheDirectory);
            result = 31 * result + Objects.hashCode(this._sleepFactor);
            result = 31 * result + Objects.hashCode(this._unavailableCapabilities);
            result = 31 * result + Objects.hashCode(this._yangLibrary);
            result = 31 * result + Objects.hashCode(this._yangModuleCapabilities);
            result = 31 * result + Objects.hashCode(this._reconnectOnChangedSchema);
            result = 31 * result + Objects.hashCode(this._schemaless);
            result = 31 * result + Objects.hashCode(this._tcpOnly);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CreateDeviceInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CreateDeviceInput other = (CreateDeviceInput)obj;
            if (!Objects.equals(this._actorResponseWaitTime, other.getActorResponseWaitTime())) {
                return false;
            }
            if (!Objects.equals(this._availableCapabilities, other.getAvailableCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._betweenAttemptsTimeoutMillis, other.getBetweenAttemptsTimeoutMillis())) {
                return false;
            }
            if (!Objects.equals(this._clusteredConnectionStatus, other.getClusteredConnectionStatus())) {
                return false;
            }
            if (!Objects.equals(this._concurrentRpcLimit, other.getConcurrentRpcLimit())) {
                return false;
            }
            if (!Objects.equals(this._connectedMessage, other.getConnectedMessage())) {
                return false;
            }
            if (!Objects.equals((Object)this._connectionStatus, (Object)other.getConnectionStatus())) {
                return false;
            }
            if (!Objects.equals(this._connectionTimeoutMillis, other.getConnectionTimeoutMillis())) {
                return false;
            }
            if (!Objects.equals(this._credentials, other.getCredentials())) {
                return false;
            }
            if (!Objects.equals(this._defaultRequestTimeoutMillis, other.getDefaultRequestTimeoutMillis())) {
                return false;
            }
            if (!Objects.equals(this._host, other.getHost())) {
                return false;
            }
            if (!Objects.equals(this._keepaliveDelay, other.getKeepaliveDelay())) {
                return false;
            }
            if (!Objects.equals(this._maxConnectionAttempts, other.getMaxConnectionAttempts())) {
                return false;
            }
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._nonModuleCapabilities, other.getNonModuleCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._odlHelloMessageCapabilities, other.getOdlHelloMessageCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._passThrough, other.getPassThrough())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._protocol, other.getProtocol())) {
                return false;
            }
            if (!Objects.equals(this._schemaCacheDirectory, other.getSchemaCacheDirectory())) {
                return false;
            }
            if (!Objects.equals(this._sleepFactor, other.getSleepFactor())) {
                return false;
            }
            if (!Objects.equals(this._unavailableCapabilities, other.getUnavailableCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._yangLibrary, other.getYangLibrary())) {
                return false;
            }
            if (!Objects.equals(this._yangModuleCapabilities, other.getYangModuleCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._reconnectOnChangedSchema, other.isReconnectOnChangedSchema())) {
                return false;
            }
            if (!Objects.equals(this._schemaless, other.isSchemaless())) {
                return false;
            }
            if (!Objects.equals(this._tcpOnly, other.isTcpOnly())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CreateDeviceInputImpl otherImpl = (CreateDeviceInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"CreateDeviceInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_actorResponseWaitTime", (Object)this._actorResponseWaitTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_availableCapabilities", (Object)this._availableCapabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_betweenAttemptsTimeoutMillis", (Object)this._betweenAttemptsTimeoutMillis);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_clusteredConnectionStatus", (Object)this._clusteredConnectionStatus);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_concurrentRpcLimit", (Object)this._concurrentRpcLimit);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_connectedMessage", (Object)this._connectedMessage);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_connectionStatus", (Object)((Object)this._connectionStatus));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_connectionTimeoutMillis", (Object)this._connectionTimeoutMillis);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_credentials", (Object)this._credentials);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_defaultRequestTimeoutMillis", (Object)this._defaultRequestTimeoutMillis);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_host", (Object)this._host);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_keepaliveDelay", (Object)this._keepaliveDelay);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxConnectionAttempts", (Object)this._maxConnectionAttempts);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeId", (Object)this._nodeId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nonModuleCapabilities", (Object)this._nonModuleCapabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_odlHelloMessageCapabilities", (Object)this._odlHelloMessageCapabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_passThrough", (Object)this._passThrough);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_port", (Object)this._port);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_protocol", (Object)this._protocol);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_schemaCacheDirectory", (Object)this._schemaCacheDirectory);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sleepFactor", (Object)this._sleepFactor);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_unavailableCapabilities", (Object)this._unavailableCapabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_yangLibrary", (Object)this._yangLibrary);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_yangModuleCapabilities", (Object)this._yangModuleCapabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_reconnectOnChangedSchema", (Object)this._reconnectOnChangedSchema);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_schemaless", (Object)this._schemaless);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_tcpOnly", (Object)this._tcpOnly);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

