/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.trusted.certificates;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.trusted.certificates.TrustedCertificate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.trusted.certificates.TrustedCertificateKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TrustedCertificateBuilder
implements Builder<TrustedCertificate> {
    private String _certificate;
    private String _name;
    private TrustedCertificateKey key;
    Map<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>> augmentation = Collections.emptyMap();

    public TrustedCertificateBuilder() {
    }

    public TrustedCertificateBuilder(TrustedCertificate base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._certificate = base.getCertificate();
        if (base instanceof TrustedCertificateImpl) {
            TrustedCertificateImpl impl = (TrustedCertificateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>>(aug);
        }
    }

    public TrustedCertificateKey key() {
        return this.key;
    }

    public String getCertificate() {
        return this._certificate;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<TrustedCertificate>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TrustedCertificateBuilder withKey(TrustedCertificateKey key) {
        this.key = key;
        return this;
    }

    public TrustedCertificateBuilder setCertificate(String value) {
        this._certificate = value;
        return this;
    }

    public TrustedCertificateBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TrustedCertificateBuilder addAugmentation(Class<? extends Augmentation<TrustedCertificate>> augmentationType, Augmentation<TrustedCertificate> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TrustedCertificateBuilder removeAugmentation(Class<? extends Augmentation<TrustedCertificate>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TrustedCertificate build() {
        return new TrustedCertificateImpl(this);
    }

    private static final class TrustedCertificateImpl
    implements TrustedCertificate {
        private final String _certificate;
        private final String _name;
        private final TrustedCertificateKey key;
        private Map<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TrustedCertificateImpl(TrustedCertificateBuilder base) {
            this.key = base.key() != null ? base.key() : new TrustedCertificateKey(base.getName());
            this._name = this.key.getName();
            this._certificate = base.getCertificate();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<TrustedCertificate> getImplementedInterface() {
            return TrustedCertificate.class;
        }

        @Override
        public TrustedCertificateKey key() {
            return this.key;
        }

        @Override
        public String getCertificate() {
            return this._certificate;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public <E$$ extends Augmentation<TrustedCertificate>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._certificate);
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TrustedCertificate.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TrustedCertificate other = (TrustedCertificate)obj;
            if (!Objects.equals(this._certificate, other.getCertificate())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TrustedCertificateImpl otherImpl = (TrustedCertificateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TrustedCertificate");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_certificate", (Object)this._certificate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

