/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry.KeyCredentialKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class KeyCredentialBuilder
implements Builder<KeyCredential> {
    private String _keyId;
    private String _passphrase;
    private String _privateKey;
    private KeyCredentialKey key;
    Map<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>> augmentation = Collections.emptyMap();

    public KeyCredentialBuilder() {
    }

    public KeyCredentialBuilder(KeyCredential base) {
        Map aug;
        this.key = base.key();
        this._keyId = base.getKeyId();
        this._passphrase = base.getPassphrase();
        this._privateKey = base.getPrivateKey();
        if (base instanceof KeyCredentialImpl) {
            KeyCredentialImpl impl = (KeyCredentialImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>>(aug);
        }
    }

    public KeyCredentialKey key() {
        return this.key;
    }

    public String getKeyId() {
        return this._keyId;
    }

    public String getPassphrase() {
        return this._passphrase;
    }

    public String getPrivateKey() {
        return this._privateKey;
    }

    public <E$$ extends Augmentation<KeyCredential>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public KeyCredentialBuilder withKey(KeyCredentialKey key) {
        this.key = key;
        return this;
    }

    public KeyCredentialBuilder setKeyId(String value) {
        this._keyId = value;
        return this;
    }

    public KeyCredentialBuilder setPassphrase(String value) {
        this._passphrase = value;
        return this;
    }

    public KeyCredentialBuilder setPrivateKey(String value) {
        this._privateKey = value;
        return this;
    }

    public KeyCredentialBuilder addAugmentation(Class<? extends Augmentation<KeyCredential>> augmentationType, Augmentation<KeyCredential> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public KeyCredentialBuilder removeAugmentation(Class<? extends Augmentation<KeyCredential>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public KeyCredential build() {
        return new KeyCredentialImpl(this);
    }

    private static final class KeyCredentialImpl
    implements KeyCredential {
        private final String _keyId;
        private final String _passphrase;
        private final String _privateKey;
        private final KeyCredentialKey key;
        private Map<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        KeyCredentialImpl(KeyCredentialBuilder base) {
            this.key = base.key() != null ? base.key() : new KeyCredentialKey(base.getKeyId());
            this._keyId = this.key.getKeyId();
            this._passphrase = base.getPassphrase();
            this._privateKey = base.getPrivateKey();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<KeyCredential> getImplementedInterface() {
            return KeyCredential.class;
        }

        @Override
        public KeyCredentialKey key() {
            return this.key;
        }

        @Override
        public String getKeyId() {
            return this._keyId;
        }

        @Override
        public String getPassphrase() {
            return this._passphrase;
        }

        @Override
        public String getPrivateKey() {
            return this._privateKey;
        }

        public <E$$ extends Augmentation<KeyCredential>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._keyId);
            result = 31 * result + Objects.hashCode(this._passphrase);
            result = 31 * result + Objects.hashCode(this._privateKey);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!KeyCredential.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            KeyCredential other = (KeyCredential)obj;
            if (!Objects.equals(this._keyId, other.getKeyId())) {
                return false;
            }
            if (!Objects.equals(this._passphrase, other.getPassphrase())) {
                return false;
            }
            if (!Objects.equals(this._privateKey, other.getPrivateKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                KeyCredentialImpl otherImpl = (KeyCredentialImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"KeyCredential");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_keyId", (Object)this._keyId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_passphrase", (Object)this._passphrase);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_privateKey", (Object)this._privateKey);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

