/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKeyKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PrivateKeyBuilder
implements Builder<PrivateKey> {
    private List<String> _certificateChain;
    private String _data;
    private String _name;
    private PrivateKeyKey key;
    Map<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>> augmentation = Collections.emptyMap();

    public PrivateKeyBuilder() {
    }

    public PrivateKeyBuilder(PrivateKey base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._certificateChain = base.getCertificateChain();
        this._data = base.getData();
        if (base instanceof PrivateKeyImpl) {
            PrivateKeyImpl impl = (PrivateKeyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>>(aug);
        }
    }

    public PrivateKeyKey key() {
        return this.key;
    }

    public List<String> getCertificateChain() {
        return this._certificateChain;
    }

    public String getData() {
        return this._data;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<PrivateKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PrivateKeyBuilder withKey(PrivateKeyKey key) {
        this.key = key;
        return this;
    }

    public PrivateKeyBuilder setCertificateChain(List<String> values) {
        this._certificateChain = values;
        return this;
    }

    public PrivateKeyBuilder setData(String value) {
        this._data = value;
        return this;
    }

    public PrivateKeyBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PrivateKeyBuilder addAugmentation(Class<? extends Augmentation<PrivateKey>> augmentationType, Augmentation<PrivateKey> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PrivateKeyBuilder removeAugmentation(Class<? extends Augmentation<PrivateKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PrivateKey build() {
        return new PrivateKeyImpl(this);
    }

    private static final class PrivateKeyImpl
    implements PrivateKey {
        private final List<String> _certificateChain;
        private final String _data;
        private final String _name;
        private final PrivateKeyKey key;
        private Map<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        PrivateKeyImpl(PrivateKeyBuilder base) {
            this.key = base.key() != null ? base.key() : new PrivateKeyKey(base.getName());
            this._name = this.key.getName();
            this._certificateChain = base.getCertificateChain();
            this._data = base.getData();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PrivateKey> getImplementedInterface() {
            return PrivateKey.class;
        }

        @Override
        public PrivateKeyKey key() {
            return this.key;
        }

        @Override
        public List<String> getCertificateChain() {
            return this._certificateChain;
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public <E$$ extends Augmentation<PrivateKey>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._certificateChain);
            result = 31 * result + Objects.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PrivateKey.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PrivateKey other = (PrivateKey)obj;
            if (!Objects.equals(this._certificateChain, other.getCertificateChain())) {
                return false;
            }
            if (!Objects.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PrivateKeyImpl otherImpl = (PrivateKeyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"PrivateKey");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_certificateChain", this._certificateChain);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_data", (Object)this._data);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

