/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.client.SslHandlerFactory;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfKeystoreAdapter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.protocol.Specification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.protocol.specification.TlsCase;

public final class SslHandlerFactoryImpl
implements SslHandlerFactory {
    private final NetconfKeystoreAdapter keystoreAdapter;
    private final @Nullable Specification specification;

    public SslHandlerFactoryImpl(NetconfKeystoreAdapter keystoreAdapter, Specification specification) {
        this.keystoreAdapter = Objects.requireNonNull(keystoreAdapter);
        this.specification = specification;
    }

    public SslHandler createSslHandler() {
        try {
            Object[] enabledProtocols;
            KeyStore keyStore = this.keystoreAdapter.getJavaKeyStore();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, "".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            SSLEngine engine = sslCtx.createSSLEngine();
            engine.setUseClientMode(true);
            Object[] engineProtocols = engine.getSupportedProtocols();
            if (this.specification != null) {
                Preconditions.checkArgument((boolean)(this.specification instanceof TlsCase), (String)"Cannot get TLS specification from: %s", (Object)this.specification);
                HashSet protocols = Sets.newHashSet((Object[])engineProtocols);
                protocols.removeAll(((TlsCase)this.specification).getTls().getExcludedVersions());
                enabledProtocols = protocols.toArray(new String[0]);
            } else {
                enabledProtocols = engineProtocols;
            }
            engine.setEnabledProtocols((String[])enabledProtocols);
            engine.setEnabledCipherSuites(engine.getSupportedCipherSuites());
            engine.setEnableSessionCreation(true);
            return new SslHandler(engine);
        }
        catch (IOException | GeneralSecurityException exc) {
            throw new IllegalStateException(exc);
        }
    }
}

