/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.util;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddKeystoreEntryInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddKeystoreEntryOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddKeystoreEntryOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddPrivateKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddPrivateKeyOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddPrivateKeyOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddTrustedCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddTrustedCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.AddTrustedCertificateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.KeystoreBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.NetconfKeystoreService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemoveKeystoreEntryInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemoveKeystoreEntryOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemoveKeystoreEntryOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemovePrivateKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemovePrivateKeyOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemovePrivateKeyOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemoveTrustedCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemoveTrustedCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.RemoveTrustedCertificateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKeyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry.KeyCredentialBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry.KeyCredentialKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.trusted.certificates.TrustedCertificate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.trusted.certificates.TrustedCertificateKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfSalKeystoreService
implements NetconfKeystoreService {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfSalKeystoreService.class);
    private final DataBroker dataBroker;
    private final AAAEncryptionService encryptionService;
    private final InstanceIdentifier<Keystore> keystoreIid = InstanceIdentifier.create(Keystore.class);

    public NetconfSalKeystoreService(DataBroker dataBroker, AAAEncryptionService encryptionService) {
        LOG.info("Starting NETCONF keystore service.");
        this.dataBroker = dataBroker;
        this.encryptionService = encryptionService;
        this.initKeystore();
    }

    private void initKeystore() {
        Keystore keystore = new KeystoreBuilder().build();
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        writeTransaction.merge(LogicalDatastoreType.CONFIGURATION, this.keystoreIid, (DataObject)keystore);
        try {
            writeTransaction.commit().get();
            LOG.debug("init keystore done");
        }
        catch (InterruptedException | ExecutionException exception) {
            LOG.error("Unable to initialize Netconf key-pair store.", (Throwable)exception);
        }
    }

    @Override
    public ListenableFuture<RpcResult<RemoveKeystoreEntryOutput>> removeKeystoreEntry(final RemoveKeystoreEntryInput input) {
        LOG.debug("Removing keypairs: {}", (Object)input);
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        List<String> ids = input.getKeyId();
        for (String id : ids) {
            writeTransaction.delete(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)this.keystoreIid.child(KeyCredential.class, (Identifier)new KeyCredentialKey(id)));
        }
        final SettableFuture rpcResult = SettableFuture.create();
        writeTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("remove-key-pair success. Input: {}", (Object)input);
                rpcResult.set((Object)RpcResultBuilder.success((Object)new RemoveKeystoreEntryOutputBuilder().build()).build());
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("remove-key-pair failed. Input: {}", (Object)input, (Object)throwable);
                rpcResult.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return rpcResult;
    }

    @Override
    public ListenableFuture<RpcResult<AddKeystoreEntryOutput>> addKeystoreEntry(final AddKeystoreEntryInput input) {
        LOG.debug("Adding keypairs: {}", (Object)input);
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        List keypairs = input.getKeyCredential().stream().map(keypair -> new KeyCredentialBuilder((KeyCredential)keypair).setPrivateKey(this.encryptionService.encrypt(keypair.getPrivateKey())).setPassphrase(this.encryptionService.encrypt(keypair.getPassphrase())).build()).collect(Collectors.toList());
        for (KeyCredential keypair2 : keypairs) {
            writeTransaction.merge(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)this.keystoreIid.child(KeyCredential.class, (Identifier)keypair2.key()), (DataObject)keypair2);
        }
        final SettableFuture rpcResult = SettableFuture.create();
        writeTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("add-key-pair success. Input: {}", (Object)input);
                rpcResult.set((Object)RpcResultBuilder.success((Object)new AddKeystoreEntryOutputBuilder().build()).build());
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("add-key-pair failed. Input: {}", (Object)input, (Object)throwable);
                rpcResult.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return rpcResult;
    }

    @Override
    public ListenableFuture<RpcResult<AddTrustedCertificateOutput>> addTrustedCertificate(final AddTrustedCertificateInput input) {
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        for (TrustedCertificate certificate : input.getTrustedCertificate()) {
            writeTransaction.merge(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)this.keystoreIid.child(TrustedCertificate.class, (Identifier)certificate.key()), (DataObject)certificate);
        }
        final SettableFuture rpcResult = SettableFuture.create();
        writeTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("add-trusted-certificate success. Input: {}", (Object)input);
                rpcResult.set((Object)RpcResultBuilder.success((Object)new AddTrustedCertificateOutputBuilder().build()).build());
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("add-trusted-certificate failed. Input: {}", (Object)input, (Object)throwable);
                rpcResult.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return rpcResult;
    }

    @Override
    public ListenableFuture<RpcResult<RemoveTrustedCertificateOutput>> removeTrustedCertificate(final RemoveTrustedCertificateInput input) {
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        List<String> names = input.getName();
        for (String name : names) {
            writeTransaction.delete(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)this.keystoreIid.child(TrustedCertificate.class, (Identifier)new TrustedCertificateKey(name)));
        }
        final SettableFuture rpcResult = SettableFuture.create();
        writeTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("remove-trusted-certificate success. Input: {}", (Object)input);
                rpcResult.set((Object)RpcResultBuilder.success((Object)new RemoveTrustedCertificateOutputBuilder().build()).build());
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("remove-trusted-certificate failed. Input: {}", (Object)input, (Object)throwable);
                rpcResult.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return rpcResult;
    }

    @Override
    public ListenableFuture<RpcResult<AddPrivateKeyOutput>> addPrivateKey(final AddPrivateKeyInput input) {
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        for (PrivateKey key : input.getPrivateKey()) {
            writeTransaction.merge(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)this.keystoreIid.child(PrivateKey.class, (Identifier)key.key()), (DataObject)key);
        }
        final SettableFuture rpcResult = SettableFuture.create();
        writeTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("add-private-key success. Input: {}", (Object)input);
                rpcResult.set((Object)RpcResultBuilder.success((Object)new AddPrivateKeyOutputBuilder().build()).build());
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("add-private-key failed. Input: {}", (Object)input, (Object)throwable);
                rpcResult.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return rpcResult;
    }

    @Override
    public ListenableFuture<RpcResult<RemovePrivateKeyOutput>> removePrivateKey(final RemovePrivateKeyInput input) {
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        List<String> names = input.getName();
        for (String name : names) {
            writeTransaction.delete(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)this.keystoreIid.child(PrivateKey.class, (Identifier)new PrivateKeyKey(name)));
        }
        final SettableFuture rpcResult = SettableFuture.create();
        writeTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("remove-private-key success. Input: {}", (Object)input);
                rpcResult.set((Object)RpcResultBuilder.success((Object)new RemovePrivateKeyOutputBuilder().build()).build());
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("remove-private-key failed. Input: {}", (Object)input, (Object)throwable);
                rpcResult.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return rpcResult;
    }
}

