/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public final class NodeContainerProxy
implements ContainerSchemaNode {
    private final Map<QName, DataSchemaNode> childNodes;
    private final QName qualifiedName;
    private final Set<AugmentationSchemaNode> availableAugmentations;

    public NodeContainerProxy(QName qualifiedName, Map<QName, DataSchemaNode> childNodes, Set<AugmentationSchemaNode> availableAugmentations) {
        this.availableAugmentations = availableAugmentations;
        this.childNodes = (Map)Preconditions.checkNotNull(childNodes, (Object)"childNodes");
        this.qualifiedName = qualifiedName;
    }

    public NodeContainerProxy(QName qualifiedName, Collection<DataSchemaNode> childNodes) {
        this(qualifiedName, NodeContainerProxy.asMap(childNodes), Collections.emptySet());
    }

    public NodeContainerProxy(QName qualifiedName, Collection<DataSchemaNode> childNodes, Set<AugmentationSchemaNode> availableAugmentations) {
        this(qualifiedName, NodeContainerProxy.asMap(childNodes), availableAugmentations);
    }

    private static Map<QName, DataSchemaNode> asMap(Collection<DataSchemaNode> childNodes) {
        return Maps.uniqueIndex(childNodes, SchemaNode::getQName);
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return Collections.emptySet();
    }

    public Set<DataSchemaNode> getChildNodes() {
        return Sets.newHashSet(this.childNodes.values());
    }

    public Set<GroupingDefinition> getGroupings() {
        return Collections.emptySet();
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        return Optional.ofNullable(this.childNodes.get(name));
    }

    public Set<UsesNode> getUses() {
        return Collections.emptySet();
    }

    public boolean isPresenceContainer() {
        throw new UnsupportedOperationException();
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return this.availableAugmentations;
    }

    public boolean isAugmenting() {
        throw new UnsupportedOperationException();
    }

    public boolean isAddedByUses() {
        throw new UnsupportedOperationException();
    }

    public boolean isConfiguration() {
        throw new UnsupportedOperationException();
    }

    public QName getQName() {
        return this.qualifiedName;
    }

    public SchemaPath getPath() {
        throw new UnsupportedOperationException();
    }

    public Optional<String> getDescription() {
        throw new UnsupportedOperationException();
    }

    public Optional<String> getReference() {
        throw new UnsupportedOperationException();
    }

    public Status getStatus() {
        throw new UnsupportedOperationException();
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public Set<NotificationDefinition> getNotifications() {
        return Collections.emptySet();
    }

    public Set<ActionDefinition> getActions() {
        return Collections.emptySet();
    }

    public Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.empty();
    }

    public Collection<MustDefinition> getMustConstraints() {
        return Collections.emptySet();
    }
}

