/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Locale;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.netconf.sal.KeepaliveSalFacade;
import org.opendaylight.netconf.sal.connect.netconf.sal.SchemalessNetconfDeviceRpc;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfRpcStructureTransformer;
import org.opendaylight.netconf.sal.connect.netconf.util.RpcStructureTransformer;
import org.opendaylight.netconf.sal.connect.netconf.util.SchemalessRpcStructureTransformer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.copy.config.input.target.ConfigTarget;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.config.input.source.ConfigSource;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class NetconfBaseOps {
    private static final YangInstanceIdentifier.NodeIdentifier CONFIG_SOURCE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)ConfigSource.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier CONFIG_TARGET_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)ConfigTarget.QNAME);
    private final DOMRpcService rpc;
    private final SchemaContext schemaContext;
    private final RpcStructureTransformer transformer;

    public NetconfBaseOps(DOMRpcService rpc, SchemaContext schemaContext) {
        this.rpc = rpc;
        this.schemaContext = schemaContext;
        this.transformer = rpc instanceof KeepaliveSalFacade.KeepaliveDOMRpcService && ((KeepaliveSalFacade.KeepaliveDOMRpcService)rpc).getDeviceRpc() instanceof SchemalessNetconfDeviceRpc ? new SchemalessRpcStructureTransformer() : new NetconfRpcStructureTransformer(schemaContext);
    }

    public FluentFuture<DOMRpcResult> lock(FutureCallback<DOMRpcResult> callback, QName datastore) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull((Object)datastore);
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_LOCK_PATH, (NormalizedNode)NetconfBaseOps.getLockContent(datastore));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> lockCandidate(FutureCallback<DOMRpcResult> callback) {
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_LOCK_PATH, (NormalizedNode)NetconfBaseOps.getLockContent(NetconfMessageTransformUtil.NETCONF_CANDIDATE_QNAME));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> lockRunning(FutureCallback<DOMRpcResult> callback) {
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_LOCK_PATH, (NormalizedNode)NetconfBaseOps.getLockContent(NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> unlock(FutureCallback<DOMRpcResult> callback, QName datastore) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull((Object)datastore);
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_UNLOCK_PATH, NetconfBaseOps.getUnLockContent(datastore));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> unlockRunning(FutureCallback<DOMRpcResult> callback) {
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_UNLOCK_PATH, NetconfBaseOps.getUnLockContent(NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> unlockCandidate(FutureCallback<DOMRpcResult> callback) {
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_UNLOCK_PATH, NetconfBaseOps.getUnLockContent(NetconfMessageTransformUtil.NETCONF_CANDIDATE_QNAME));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> discardChanges(FutureCallback<DOMRpcResult> callback) {
        Preconditions.checkNotNull(callback);
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_DISCARD_CHANGES_PATH, null);
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> commit(FutureCallback<DOMRpcResult> callback) {
        Preconditions.checkNotNull(callback);
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_COMMIT_PATH, (NormalizedNode)NetconfMessageTransformUtil.COMMIT_RPC_CONTENT);
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> validate(FutureCallback<DOMRpcResult> callback, QName datastore) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull((Object)datastore);
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_VALIDATE_PATH, NetconfBaseOps.getValidateContent(datastore));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> validateCandidate(FutureCallback<DOMRpcResult> callback) {
        return this.validate(callback, NetconfMessageTransformUtil.NETCONF_CANDIDATE_QNAME);
    }

    public FluentFuture<DOMRpcResult> validateRunning(FutureCallback<DOMRpcResult> callback) {
        return this.validate(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME);
    }

    public FluentFuture<DOMRpcResult> copyConfig(FutureCallback<DOMRpcResult> callback, QName source, QName target) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_COPY_CONFIG_PATH, NetconfBaseOps.getCopyConfigContent(source, target));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<DOMRpcResult> copyRunningToCandidate(FutureCallback<DOMRpcResult> callback) {
        return this.copyConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME, NetconfMessageTransformUtil.NETCONF_CANDIDATE_QNAME);
    }

    public FluentFuture<DOMRpcResult> getConfig(FutureCallback<DOMRpcResult> callback, QName datastore, Optional<YangInstanceIdentifier> filterPath) {
        FluentFuture future;
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull((Object)datastore);
        if (NetconfBaseOps.isFilterPresent(filterPath)) {
            DataContainerChild<?, ?> node = this.transformer.toFilterStructure(filterPath.get());
            future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_PATH, (NormalizedNode)NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, NetconfBaseOps.getSourceNode(datastore), node));
        } else {
            future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_PATH, (NormalizedNode)NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_NODEID, NetconfBaseOps.getSourceNode(datastore)));
        }
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> getConfigRunningData(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        FluentFuture<DOMRpcResult> configRunning = this.getConfigRunning(callback, filterPath);
        return this.extractData(filterPath, configRunning);
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> getData(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        FluentFuture<DOMRpcResult> configRunning = this.get(callback, filterPath);
        return this.extractData(filterPath, configRunning);
    }

    private FluentFuture<Optional<NormalizedNode<?, ?>>> extractData(Optional<YangInstanceIdentifier> path, FluentFuture<DOMRpcResult> configRunning) {
        return configRunning.transform(result -> {
            Preconditions.checkArgument((boolean)result.getErrors().isEmpty(), (String)"Unable to read data: %s, errors: %s", (Object)path, (Object)result.getErrors());
            DataContainerChild dataNode = (DataContainerChild)((ContainerNode)result.getResult()).getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID).get();
            return this.transformer.selectFromDataStructure(dataNode, (YangInstanceIdentifier)path.get());
        }, MoreExecutors.directExecutor());
    }

    public FluentFuture<DOMRpcResult> getConfigRunning(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        return this.getConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME, filterPath);
    }

    public FluentFuture<DOMRpcResult> getConfigCandidate(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        return this.getConfig(callback, NetconfMessageTransformUtil.NETCONF_CANDIDATE_QNAME, filterPath);
    }

    public FluentFuture<DOMRpcResult> get(FutureCallback<DOMRpcResult> callback, Optional<YangInstanceIdentifier> filterPath) {
        Preconditions.checkNotNull(callback);
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_PATH, (NormalizedNode)(NetconfBaseOps.isFilterPresent(filterPath) ? NetconfMessageTransformUtil.wrap(NetconfMessageTransformUtil.NETCONF_GET_NODEID, NetconfMessageTransformUtil.toFilterStructure(filterPath.get(), this.schemaContext)) : NetconfMessageTransformUtil.GET_RPC_CONTENT));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    private static boolean isFilterPresent(Optional<YangInstanceIdentifier> filterPath) {
        return filterPath.isPresent() && !filterPath.get().isEmpty();
    }

    public FluentFuture<DOMRpcResult> editConfigCandidate(FutureCallback<? super DOMRpcResult> callback, DataContainerChild<?, ?> editStructure, ModifyAction modifyAction, boolean rollback) {
        return this.editConfig(callback, NetconfMessageTransformUtil.NETCONF_CANDIDATE_QNAME, editStructure, Optional.of(modifyAction), rollback);
    }

    public FluentFuture<DOMRpcResult> editConfigCandidate(FutureCallback<? super DOMRpcResult> callback, DataContainerChild<?, ?> editStructure, boolean rollback) {
        return this.editConfig(callback, NetconfMessageTransformUtil.NETCONF_CANDIDATE_QNAME, editStructure, Optional.empty(), rollback);
    }

    public FluentFuture<DOMRpcResult> editConfigRunning(FutureCallback<? super DOMRpcResult> callback, DataContainerChild<?, ?> editStructure, ModifyAction modifyAction, boolean rollback) {
        return this.editConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME, editStructure, Optional.of(modifyAction), rollback);
    }

    public FluentFuture<DOMRpcResult> editConfigRunning(FutureCallback<? super DOMRpcResult> callback, DataContainerChild<?, ?> editStructure, boolean rollback) {
        return this.editConfig(callback, NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME, editStructure, Optional.empty(), rollback);
    }

    public FluentFuture<DOMRpcResult> editConfig(FutureCallback<? super DOMRpcResult> callback, QName datastore, DataContainerChild<?, ?> editStructure, Optional<ModifyAction> modifyAction, boolean rollback) {
        Preconditions.checkNotNull(editStructure);
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull((Object)datastore);
        FluentFuture future = this.rpc.invokeRpc(NetconfMessageTransformUtil.NETCONF_EDIT_CONFIG_PATH, (NormalizedNode)NetconfBaseOps.getEditConfigContent(datastore, editStructure, modifyAction, rollback));
        future.addCallback(callback, MoreExecutors.directExecutor());
        return future;
    }

    public DataContainerChild<?, ?> createEditConfigStrcture(Optional<NormalizedNode<?, ?>> lastChild, Optional<ModifyAction> operation, YangInstanceIdentifier dataPath) {
        AnyXmlNode configContent = this.transformer.createEditConfigStructure(lastChild, dataPath, operation);
        return (DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.EDIT_CONTENT_NODEID).withChild((DataContainerChild)configContent).build();
    }

    private static ContainerNode getEditConfigContent(QName datastore, DataContainerChild<?, ?> editStructure, Optional<ModifyAction> defaultOperation, boolean rollback) {
        DataContainerNodeAttrBuilder editBuilder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_EDIT_CONFIG_NODEID);
        editBuilder.withChild(NetconfBaseOps.getTargetNode(datastore));
        if (defaultOperation.isPresent()) {
            String opString = defaultOperation.get().name().toLowerCase(Locale.ROOT);
            editBuilder.withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DEFAULT_OPERATION_NODEID).withValue((Object)opString).build());
        }
        if (rollback) {
            editBuilder.withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_ERROR_OPTION_NODEID).withValue((Object)"rollback-on-error").build());
        }
        editBuilder.withChild(editStructure);
        return (ContainerNode)editBuilder.build();
    }

    public static DataContainerChild<?, ?> getSourceNode(QName datastore) {
        return (DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_SOURCE_NODEID).withChild((DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CONFIG_SOURCE_NODEID).withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId(datastore)).withValue((Object)Empty.getInstance()).build()).build()).build();
    }

    public static ContainerNode getLockContent(QName datastore) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_LOCK_NODEID).withChild(NetconfBaseOps.getTargetNode(datastore)).build();
    }

    public static DataContainerChild<?, ?> getTargetNode(QName datastore) {
        return (DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_TARGET_NODEID).withChild((DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CONFIG_TARGET_NODEID).withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId(datastore)).withValue((Object)Empty.getInstance()).build()).build()).build();
    }

    public static NormalizedNode<?, ?> getCopyConfigContent(QName source, QName target) {
        return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_COPY_CONFIG_NODEID).withChild(NetconfBaseOps.getTargetNode(target)).withChild(NetconfBaseOps.getSourceNode(source)).build();
    }

    public static NormalizedNode<?, ?> getValidateContent(QName source) {
        return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_VALIDATE_NODEID).withChild(NetconfBaseOps.getSourceNode(source)).build();
    }

    public static NormalizedNode<?, ?> getUnLockContent(QName datastore) {
        return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_UNLOCK_NODEID).withChild(NetconfBaseOps.getTargetNode(datastore)).build();
    }
}

