/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.schema.mapping;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.sal.connect.api.MessageTransformer;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseSchema;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.MessageCounter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseRpcSchemalessTransformer
implements MessageTransformer<NetconfMessage> {
    private static final Map<QName, RpcDefinition> MAPPED_RPCS = BaseSchema.BASE_NETCONF_CTX.getMappedRpcs();
    private static final SchemaContext SCHEMA_CONTEXT = BaseSchema.BASE_NETCONF_CTX.getSchemaContext();
    private final MessageCounter counter;

    public BaseRpcSchemalessTransformer(MessageCounter counter) {
        this.counter = counter;
    }

    @Override
    public DOMNotification toNotification(NetconfMessage message) {
        throw new UnsupportedOperationException("Notifications not supported.");
    }

    @Override
    public NetconfMessage toRpcRequest(SchemaPath rpc, NormalizedNode<?, ?> payload) {
        QName rpcQName = rpc.getLastComponent();
        RpcDefinition mappedRpc = (RpcDefinition)Preconditions.checkNotNull((Object)MAPPED_RPCS.get(rpcQName), (String)"Unknown rpc %s, available rpcs: %s", (Object)rpcQName, MAPPED_RPCS.keySet());
        DOMResult domResult = NetconfMessageTransformUtil.prepareDomResultForRpcRequest(rpcQName, this.counter);
        if (mappedRpc.getInput().getChildNodes().isEmpty()) {
            return new NetconfMessage(domResult.getNode().getOwnerDocument());
        }
        Preconditions.checkNotNull(payload, (String)"Transforming an rpc with input: %s, payload cannot be null", (Object)rpcQName);
        Preconditions.checkArgument((boolean)(payload instanceof ContainerNode), (String)"Transforming an rpc with input: %s, payload has to be a container, but was: %s", (Object)rpcQName, payload);
        SchemaPath inputPath = rpc.createChild(YangConstants.operationInputQName((QNameModule)rpcQName.getModule()));
        DOMResult result = domResult;
        try {
            NetconfMessageTransformUtil.writeNormalizedRpc((ContainerNode)payload, result, inputPath, SCHEMA_CONTEXT);
        }
        catch (IOException | IllegalStateException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize " + inputPath, e);
        }
        Document node = result.getNode().getOwnerDocument();
        return new NetconfMessage(node);
    }

    @Override
    public DOMRpcResult toRpcResult(NetconfMessage message, SchemaPath rpc) {
        NormalizedNode normalizedNode;
        QName rpcQName = rpc.getLastComponent();
        if (NetconfMessageTransformUtil.isDataRetrievalOperation(rpcQName)) {
            Element xmlData = NetconfMessageTransformUtil.getDataSubtree(message.getDocument());
            Document data = XmlUtil.newDocument();
            data.appendChild(data.importNode(xmlData, true));
            AnyXmlNode xmlDataNode = (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID).withValue((Object)new DOMSource(data)).build();
            normalizedNode = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(NetconfMessageTransformUtil.NETCONF_RPC_REPLY_QNAME)).withChild((DataContainerChild)xmlDataNode).build();
        } else {
            Preconditions.checkArgument((boolean)BaseRpcSchemalessTransformer.isOkPresent(message.getDocument()), (String)"Unexpected content in response of rpc: %s, %s", (Object)rpc.getLastComponent(), (Object)message);
            normalizedNode = null;
        }
        return new DefaultDOMRpcResult(normalizedNode);
    }

    static boolean isOkPresent(Document doc) {
        return XmlElement.fromDomDocument((Document)doc).getOnlyChildElementWithSameNamespaceOptionally("ok").isPresent();
    }
}

