/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.netconf.sal.connect.netconf.schema.NetconfRemoteSchemaYangSourceProvider;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangLibrarySchemaYangSourceProvider
implements SchemaSourceProvider<YangTextSchemaSource> {
    private static final Logger LOG = LoggerFactory.getLogger(YangLibrarySchemaYangSourceProvider.class);
    private final Map<SourceIdentifier, URL> availableSources;
    private final RemoteDeviceId id;

    public YangLibrarySchemaYangSourceProvider(RemoteDeviceId id, Map<SourceIdentifier, URL> availableSources) {
        this.id = id;
        this.availableSources = ImmutableMap.copyOf(availableSources);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        URL url = this.availableSources.get(Objects.requireNonNull(sourceIdentifier));
        Preconditions.checkArgument((url != null ? 1 : 0) != 0);
        try (InputStream in = url.openStream();){
            String schemaContent = new String(ByteStreams.toByteArray((InputStream)in), Charset.defaultCharset());
            NetconfRemoteSchemaYangSourceProvider.NetconfYangTextSchemaSource yangSource = new NetconfRemoteSchemaYangSourceProvider.NetconfYangTextSchemaSource(this.id, sourceIdentifier, Optional.of(schemaContent));
            LOG.debug("Source {} downloaded from a yang library's url {}", (Object)sourceIdentifier, (Object)url);
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)((Object)yangSource));
            return listenableFuture;
        }
        catch (IOException e) {
            LOG.warn("Unable to download source {} from a yang library's url {}", new Object[]{sourceIdentifier, url, e});
            return Futures.immediateFailedFuture((Throwable)new SchemaSourceException("Unable to download remote schema for " + sourceIdentifier + " from " + url, (Throwable)e));
        }
    }
}

