/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.schema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class NetconfRemoteSchemaYangSourceProvider
implements SchemaSourceProvider<YangTextSchemaSource> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfRemoteSchemaYangSourceProvider.class);
    private static final YangInstanceIdentifier.NodeIdentifier FORMAT_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NetconfMessageTransformUtil.GET_SCHEMA_QNAME, (String)"format").intern());
    private static final YangInstanceIdentifier.NodeIdentifier GET_SCHEMA_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)NetconfMessageTransformUtil.GET_SCHEMA_QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier IDENTIFIER_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NetconfMessageTransformUtil.GET_SCHEMA_QNAME, (String)"identifier").intern());
    private static final YangInstanceIdentifier.NodeIdentifier VERSION_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NetconfMessageTransformUtil.GET_SCHEMA_QNAME, (String)"version").intern());
    private static final LeafNode<?> FORMAT_LEAF = (LeafNode)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)FORMAT_PATHARG).withValue((Object)Yang.QNAME).build();
    private static final QName NETCONF_DATA = QName.create((QName)NetconfMessageTransformUtil.GET_SCHEMA_QNAME, (String)NetconfMessageTransformUtil.NETCONF_DATA_QNAME.getLocalName()).intern();
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_DATA_PATHARG = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_DATA);
    private final DOMRpcService rpc;
    private final RemoteDeviceId id;

    public NetconfRemoteSchemaYangSourceProvider(RemoteDeviceId id, DOMRpcService rpc) {
        this.id = id;
        this.rpc = Objects.requireNonNull(rpc);
    }

    public static ContainerNode createGetSchemaRequest(String moduleName, Optional<String> revision) {
        LeafNode identifier = (LeafNode)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)IDENTIFIER_PATHARG).withValue((Object)moduleName).build();
        DataContainerNodeAttrBuilder builder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)GET_SCHEMA_PATHARG).withChild((DataContainerChild)identifier).withChild(FORMAT_LEAF);
        if (revision.isPresent()) {
            builder.withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)VERSION_PATHARG).withValue((Object)revision.get()).build());
        }
        return (ContainerNode)builder.build();
    }

    private static Optional<String> getSchemaFromRpc(RemoteDeviceId id, NormalizedNode<?, ?> result) {
        if (result == null) {
            return Optional.empty();
        }
        Optional child = ((ContainerNode)result).getChild((YangInstanceIdentifier.PathArgument)NETCONF_DATA_PATHARG);
        Preconditions.checkState((child.isPresent() && child.get() instanceof AnyXmlNode ? 1 : 0) != 0, (String)"%s Unexpected response to get-schema, expected response with one child %s, but was %s", (Object)id, (Object)NETCONF_DATA, result);
        DOMSource wrappedNode = ((AnyXmlNode)child.get()).getValue();
        Element dataNode = (Element)Objects.requireNonNull(wrappedNode.getNode());
        return Optional.of(dataNode.getTextContent().trim());
    }

    public ListenableFuture<YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        String moduleName = sourceIdentifier.getName();
        Optional<String> revision = sourceIdentifier.getRevision().map(Revision::toString);
        ContainerNode getSchemaRequest = NetconfRemoteSchemaYangSourceProvider.createGetSchemaRequest(moduleName, revision);
        LOG.trace("{}: Loading YANG schema source for {}:{}", new Object[]{this.id, moduleName, revision});
        return Futures.transform((ListenableFuture)this.rpc.invokeRpc(SchemaPath.create((boolean)true, (QName[])new QName[]{NetconfMessageTransformUtil.GET_SCHEMA_QNAME}), (NormalizedNode)getSchemaRequest), input -> {
            if (input.getErrors().isEmpty()) {
                Optional<String> schemaString = NetconfRemoteSchemaYangSourceProvider.getSchemaFromRpc(this.id, input.getResult());
                Preconditions.checkState((boolean)schemaString.isPresent(), (String)"%s: Unexpected response to get-schema, schema not present in message for: %s", (Object)this.id, (Object)sourceIdentifier);
                LOG.debug("{}: YANG Schema successfully retrieved for {}:{}", new Object[]{this.id, moduleName, revision});
                return new NetconfYangTextSchemaSource(this.id, sourceIdentifier, schemaString);
            }
            LOG.warn("{}: YANG schema was not successfully retrieved for {}. Errors: {}", new Object[]{this.id, sourceIdentifier, input.getErrors()});
            throw new IllegalStateException(String.format("%s: YANG schema was not successfully retrieved for %s. Errors: %s", this.id, sourceIdentifier, input.getErrors()));
        }, (Executor)MoreExecutors.directExecutor());
    }

    static class NetconfYangTextSchemaSource
    extends YangTextSchemaSource {
        private final RemoteDeviceId id;
        private final Optional<String> schemaString;

        NetconfYangTextSchemaSource(RemoteDeviceId id, SourceIdentifier sourceIdentifier, Optional<String> schemaString) {
            super(sourceIdentifier);
            this.id = id;
            this.schemaString = schemaString;
        }

        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("device", (Object)this.id);
        }

        public InputStream openStream() {
            return new ByteArrayInputStream(this.schemaString.get().getBytes(StandardCharsets.UTF_8));
        }
    }
}

