/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal.tx;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.AbstractWriteTx;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfBaseOps;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfRpcFutureCallback;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteRunningTx
extends AbstractWriteTx {
    private static final Logger LOG = LoggerFactory.getLogger(WriteRunningTx.class);
    private final List<Change> changes = new ArrayList<Change>();

    public WriteRunningTx(RemoteDeviceId id, NetconfBaseOps netOps, boolean rollbackSupport) {
        super(netOps, id, rollbackSupport);
    }

    @Override
    protected synchronized void init() {
        this.lock();
    }

    private void lock() {
        this.resultsFutures.add(this.netOps.lockRunning(new NetconfRpcFutureCallback("Lock running", this.id)));
    }

    @Override
    protected void cleanup() {
        this.unlock();
    }

    @Override
    public synchronized ListenableFuture<RpcResult<Void>> performCommit() {
        for (Change change : this.changes) {
            this.resultsFutures.add(change.execute(this.id, this.netOps, this.rollbackSupport));
        }
        this.unlock();
        return this.resultsToTxStatus();
    }

    @Override
    protected void editConfig(YangInstanceIdentifier path, Optional<NormalizedNode<?, ?>> data, DataContainerChild<?, ?> editStructure, Optional<ModifyAction> defaultOperation, String operation) {
        this.changes.add(new Change(editStructure, defaultOperation));
    }

    private void unlock() {
        this.netOps.unlockRunning(new NetconfRpcFutureCallback("Unlock running", this.id));
    }

    private static final class Change {
        private final DataContainerChild<?, ?> editStructure;
        private final Optional<ModifyAction> defaultOperation;

        Change(DataContainerChild<?, ?> editStructure, Optional<ModifyAction> defaultOperation) {
            this.editStructure = editStructure;
            this.defaultOperation = defaultOperation;
        }

        private ListenableFuture<DOMRpcResult> execute(RemoteDeviceId id, NetconfBaseOps netOps, boolean rollbackSupport) {
            NetconfRpcFutureCallback editConfigCallback = new NetconfRpcFutureCallback("Edit running", id);
            if (this.defaultOperation.isPresent()) {
                return netOps.editConfigRunning(editConfigCallback, this.editStructure, this.defaultOperation.get(), rollbackSupport);
            }
            return netOps.editConfigRunning(editConfigCallback, this.editStructure, rollbackSupport);
        }
    }
}

