/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal.tx;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainClosedException;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.AbstractWriteTx;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.ReadWriteTx;
import org.opendaylight.netconf.sal.connect.netconf.sal.tx.TxListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxChain
implements DOMTransactionChain,
TxListener {
    private static final Logger LOG = LoggerFactory.getLogger(TxChain.class);
    private final DOMDataBroker dataBroker;
    private final DOMTransactionChainListener listener;
    private final Map<DOMDataTreeWriteTransaction, AutoCloseable> pendingTransactions = new HashMap<DOMDataTreeWriteTransaction, AutoCloseable>();
    private AbstractWriteTx currentTransaction = null;
    private boolean closed = false;
    private boolean successful = true;

    public TxChain(DOMDataBroker dataBroker, DOMTransactionChainListener listener) {
        this.dataBroker = dataBroker;
        this.listener = listener;
    }

    public synchronized DOMDataTreeReadTransaction newReadOnlyTransaction() {
        this.checkOperationPermitted();
        return this.dataBroker.newReadOnlyTransaction();
    }

    public synchronized AbstractWriteTx newWriteOnlyTransaction() {
        this.checkOperationPermitted();
        DOMDataTreeWriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        Preconditions.checkState((boolean)(writeTransaction instanceof AbstractWriteTx));
        AbstractWriteTx pendingWriteTx = (AbstractWriteTx)writeTransaction;
        this.pendingTransactions.put(pendingWriteTx, pendingWriteTx.addListener(this));
        this.currentTransaction = pendingWriteTx;
        return pendingWriteTx;
    }

    public synchronized DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return new ReadWriteTx(this.dataBroker.newReadOnlyTransaction(), this.newWriteOnlyTransaction());
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.notifyChainListenerSuccess();
        }
    }

    @Override
    public synchronized void onTransactionSuccessful(AbstractWriteTx transaction) {
        this.removePendingTx(transaction);
        this.notifyChainListenerSuccess();
    }

    @Override
    public synchronized void onTransactionFailed(AbstractWriteTx transaction, Throwable cause) {
        this.removePendingTx(transaction);
        this.successful = false;
        if (this.currentTransaction != null) {
            this.currentTransaction.cancel();
        }
        this.listener.onTransactionChainFailed((DOMTransactionChain)this, (DOMDataTreeTransaction)transaction, cause);
    }

    @Override
    public synchronized void onTransactionSubmitted(AbstractWriteTx transaction) {
        this.currentTransaction = null;
    }

    @Override
    public synchronized void onTransactionCancelled(AbstractWriteTx transaction) {
        this.removePendingTx(transaction);
        this.currentTransaction = null;
    }

    private void removePendingTx(AbstractWriteTx transaction) {
        try {
            this.pendingTransactions.remove(transaction).close();
        }
        catch (Exception e) {
            LOG.error("Can't remove transaction listener registration", (Throwable)e);
        }
    }

    private void checkOperationPermitted() {
        if (this.closed) {
            throw new DOMTransactionChainClosedException("Transaction chain was closed");
        }
        Preconditions.checkState((this.currentTransaction == null ? 1 : 0) != 0, (Object)"Last write transaction has not finished yet");
    }

    private void notifyChainListenerSuccess() {
        if (this.closed && this.pendingTransactions.isEmpty() && this.successful) {
            this.listener.onTransactionChainSuccessful((DOMTransactionChain)this);
        }
    }
}

