/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal.tx;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfBaseOps;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfRpcFutureCallback;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadOnlyTx
implements DOMDataTreeReadTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyTx.class);
    private final NetconfBaseOps netconfOps;
    private final RemoteDeviceId id;

    public ReadOnlyTx(NetconfBaseOps netconfOps, RemoteDeviceId id) {
        this.netconfOps = netconfOps;
        this.id = id;
    }

    private FluentFuture<Optional<NormalizedNode<?, ?>>> readConfigurationData(YangInstanceIdentifier path) {
        return ReadOnlyTx.remapException(this.netconfOps.getConfigRunningData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path)));
    }

    private FluentFuture<Optional<NormalizedNode<?, ?>>> readOperationalData(YangInstanceIdentifier path) {
        return ReadOnlyTx.remapException(this.netconfOps.getData(new NetconfRpcFutureCallback("Data read", this.id), Optional.ofNullable(path)));
    }

    private static <T> FluentFuture<T> remapException(FluentFuture<T> input) {
        final SettableFuture ret = SettableFuture.create();
        input.addCallback(new FutureCallback<T>(){

            public void onSuccess(T result) {
                ret.set(result);
            }

            public void onFailure(Throwable cause) {
                ret.setException(cause instanceof ReadFailedException ? cause : new ReadFailedException("NETCONF operation failed", cause, new RpcError[0]));
            }
        }, MoreExecutors.directExecutor());
        return ret;
    }

    public void close() {
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        switch (store) {
            case CONFIGURATION: {
                return this.readConfigurationData(path);
            }
            case OPERATIONAL: {
                return this.readOperationalData(path);
            }
        }
        LOG.info("Unknown datastore type: {}.", (Object)store);
        throw new IllegalArgumentException(String.format("%s, Cannot read data %s for %s datastore, unknown datastore type", this.id, path, store));
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.read(store, path).transform(optionalNode -> optionalNode != null && optionalNode.isPresent(), MoreExecutors.directExecutor());
    }

    public Object getIdentifier() {
        return this;
    }
}

