/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCapabilities;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.AvailableCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.ClusteredConnectionStatusBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.UnavailableCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.UnavailableCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.unavailable.capabilities.UnavailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.unavailable.capabilities.UnavailableCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfDeviceTopologyAdapter
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceTopologyAdapter.class);
    private final RemoteDeviceId id;
    private TransactionChain txChain;
    private final InstanceIdentifier<NetworkTopology> networkTopologyPath;
    private final KeyedInstanceIdentifier<Topology, TopologyKey> topologyListPath;
    private static final String UNKNOWN_REASON = "Unknown reason";

    NetconfDeviceTopologyAdapter(RemoteDeviceId id, TransactionChain txChain) {
        this.id = id;
        this.txChain = (TransactionChain)Preconditions.checkNotNull((Object)txChain);
        this.networkTopologyPath = InstanceIdentifier.builder(NetworkTopology.class).build();
        this.topologyListPath = this.networkTopologyPath.child(Topology.class, (Identifier)new TopologyKey(new TopologyId(TopologyNetconf.QNAME.getLocalName())));
        this.initDeviceData();
    }

    private void initDeviceData() {
        WriteTransaction writeTx = this.txChain.newWriteOnlyTransaction();
        this.createNetworkTopologyIfNotPresent(writeTx);
        InstanceIdentifier<Node> path = this.id.getTopologyBindingPath();
        NodeBuilder nodeBuilder = NetconfDeviceTopologyAdapter.getNodeIdBuilder(this.id);
        NetconfNodeBuilder netconfNodeBuilder = new NetconfNodeBuilder();
        netconfNodeBuilder.setConnectionStatus(NetconfNodeConnectionStatus.ConnectionStatus.Connecting);
        netconfNodeBuilder.setHost(this.id.getHost());
        netconfNodeBuilder.setPort(new PortNumber(Integer.valueOf(this.id.getAddress().getPort())));
        nodeBuilder.addAugmentation(NetconfNode.class, (Augmentation)netconfNodeBuilder.build());
        Node node = nodeBuilder.build();
        LOG.trace("{}: Init device state transaction {} putting if absent operational data started.", (Object)this.id, writeTx.getIdentifier());
        writeTx.put(LogicalDatastoreType.OPERATIONAL, path, (DataObject)node);
        LOG.trace("{}: Init device state transaction {} putting operational data ended.", (Object)this.id, writeTx.getIdentifier());
        LOG.trace("{}: Init device state transaction {} putting if absent config data started.", (Object)this.id, writeTx.getIdentifier());
        LOG.trace("{}: Init device state transaction {} putting config data ended.", (Object)this.id, writeTx.getIdentifier());
        this.commitTransaction(writeTx, "init");
    }

    public void updateDeviceData(boolean up, NetconfDeviceCapabilities capabilities) {
        NetconfNode data = this.buildDataForNetconfNode(up, capabilities);
        WriteTransaction writeTx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Update device state transaction {} merging operational data started.", (Object)this.id, writeTx.getIdentifier());
        writeTx.put(LogicalDatastoreType.OPERATIONAL, this.id.getTopologyBindingPath().augmentation(NetconfNode.class), (DataObject)data, true);
        LOG.trace("{}: Update device state transaction {} merging operational data ended.", (Object)this.id, writeTx.getIdentifier());
        this.commitTransaction(writeTx, "update");
    }

    public void updateClusteredDeviceData(boolean up, String masterAddress, NetconfDeviceCapabilities capabilities) {
        NetconfNode data = this.buildDataForNetconfClusteredNode(up, masterAddress, capabilities);
        WriteTransaction writeTx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Update device state transaction {} merging operational data started.", (Object)this.id, writeTx.getIdentifier());
        writeTx.put(LogicalDatastoreType.OPERATIONAL, this.id.getTopologyBindingPath().augmentation(NetconfNode.class), (DataObject)data, true);
        LOG.trace("{}: Update device state transaction {} merging operational data ended.", (Object)this.id, writeTx.getIdentifier());
        this.commitTransaction(writeTx, "update");
    }

    public void setDeviceAsFailed(Throwable throwable) {
        String reason = throwable != null && throwable.getMessage() != null ? throwable.getMessage() : UNKNOWN_REASON;
        NetconfNode data = new NetconfNodeBuilder().setHost(this.id.getHost()).setPort(new PortNumber(Integer.valueOf(this.id.getAddress().getPort()))).setConnectionStatus(NetconfNodeConnectionStatus.ConnectionStatus.UnableToConnect).setConnectedMessage(reason).build();
        WriteTransaction writeTx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Setting device state as failed {} putting operational data started.", (Object)this.id, writeTx.getIdentifier());
        writeTx.put(LogicalDatastoreType.OPERATIONAL, this.id.getTopologyBindingPath().augmentation(NetconfNode.class), (DataObject)data, true);
        LOG.trace("{}: Setting device state as failed {} putting operational data ended.", (Object)this.id, writeTx.getIdentifier());
        this.commitTransaction(writeTx, "update-failed-device");
    }

    private NetconfNode buildDataForNetconfNode(boolean up, NetconfDeviceCapabilities capabilities) {
        ArrayList<AvailableCapability> capabilityList = new ArrayList<AvailableCapability>();
        capabilityList.addAll(capabilities.getNonModuleBasedCapabilities());
        capabilityList.addAll(capabilities.getResolvedCapabilities());
        AvailableCapabilitiesBuilder avCapabalitiesBuilder = new AvailableCapabilitiesBuilder();
        avCapabalitiesBuilder.setAvailableCapability(capabilityList);
        NetconfNodeBuilder netconfNodeBuilder = new NetconfNodeBuilder().setHost(this.id.getHost()).setPort(new PortNumber(Integer.valueOf(this.id.getAddress().getPort()))).setConnectionStatus(up ? NetconfNodeConnectionStatus.ConnectionStatus.Connected : NetconfNodeConnectionStatus.ConnectionStatus.Connecting).setAvailableCapabilities(avCapabalitiesBuilder.build()).setUnavailableCapabilities(NetconfDeviceTopologyAdapter.unavailableCapabilities(capabilities.getUnresolvedCapabilites()));
        return netconfNodeBuilder.build();
    }

    private NetconfNode buildDataForNetconfClusteredNode(boolean up, String masterNodeAddress, NetconfDeviceCapabilities capabilities) {
        ArrayList<AvailableCapability> capabilityList = new ArrayList<AvailableCapability>();
        capabilityList.addAll(capabilities.getNonModuleBasedCapabilities());
        capabilityList.addAll(capabilities.getResolvedCapabilities());
        AvailableCapabilitiesBuilder avCapabalitiesBuilder = new AvailableCapabilitiesBuilder();
        avCapabalitiesBuilder.setAvailableCapability(capabilityList);
        NetconfNodeBuilder netconfNodeBuilder = new NetconfNodeBuilder().setHost(this.id.getHost()).setPort(new PortNumber(Integer.valueOf(this.id.getAddress().getPort()))).setConnectionStatus(up ? NetconfNodeConnectionStatus.ConnectionStatus.Connected : NetconfNodeConnectionStatus.ConnectionStatus.Connecting).setAvailableCapabilities(avCapabalitiesBuilder.build()).setUnavailableCapabilities(NetconfDeviceTopologyAdapter.unavailableCapabilities(capabilities.getUnresolvedCapabilites())).setClusteredConnectionStatus(new ClusteredConnectionStatusBuilder().setNetconfMasterNode(masterNodeAddress).build());
        return netconfNodeBuilder.build();
    }

    private static UnavailableCapabilities unavailableCapabilities(Map<QName, UnavailableCapability.FailureReason> input) {
        return new UnavailableCapabilitiesBuilder().setUnavailableCapability(input.entrySet().stream().map(e -> new UnavailableCapabilityBuilder().setCapability(((QName)e.getKey()).toString()).setFailureReason((UnavailableCapability.FailureReason)((Object)((Object)e.getValue()))).build()).collect(Collectors.toList())).build();
    }

    public void removeDeviceConfiguration() {
        WriteTransaction writeTx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Close device state transaction {} removing all data started.", (Object)this.id, writeTx.getIdentifier());
        writeTx.delete(LogicalDatastoreType.OPERATIONAL, this.id.getTopologyBindingPath());
        LOG.trace("{}: Close device state transaction {} removing all data ended.", (Object)this.id, writeTx.getIdentifier());
        try {
            writeTx.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("{}: Transaction(close) {} FAILED!", new Object[]{this.id, writeTx.getIdentifier(), e});
            throw new IllegalStateException(this.id + "  Transaction(close) not committed correctly", e);
        }
    }

    private void createNetworkTopologyIfNotPresent(WriteTransaction writeTx) {
        NetworkTopology networkTopology = new NetworkTopologyBuilder().build();
        LOG.trace("{}: Transaction {} merging {} container to ensure its presence", new Object[]{this.id, writeTx.getIdentifier(), NetworkTopology.QNAME});
        writeTx.merge(LogicalDatastoreType.OPERATIONAL, this.networkTopologyPath, (DataObject)networkTopology);
        Topology topology = new TopologyBuilder().setTopologyId(new TopologyId(TopologyNetconf.QNAME.getLocalName())).build();
        LOG.trace("{}: Transaction {} merging {} container to ensure its presence", new Object[]{this.id, writeTx.getIdentifier(), Topology.QNAME});
        writeTx.merge(LogicalDatastoreType.OPERATIONAL, this.topologyListPath, (DataObject)topology);
    }

    private void commitTransaction(final WriteTransaction transaction, final String txType) {
        LOG.trace("{}: Committing Transaction {}:{}", new Object[]{this.id, txType, transaction.getIdentifier()});
        transaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("{}: Transaction({}) {} SUCCESSFUL", new Object[]{NetconfDeviceTopologyAdapter.this.id, txType, transaction.getIdentifier()});
            }

            public void onFailure(Throwable throwable) {
                LOG.error("{}: Transaction({}) {} FAILED!", new Object[]{NetconfDeviceTopologyAdapter.this.id, txType, transaction.getIdentifier(), throwable});
                throw new IllegalStateException(NetconfDeviceTopologyAdapter.this.id + "  Transaction(" + txType + ") not committed correctly", throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    private static NodeBuilder getNodeIdBuilder(RemoteDeviceId id) {
        NodeBuilder nodeBuilder = new NodeBuilder();
        nodeBuilder.withKey(new NodeKey(new NodeId(id.getName())));
        return nodeBuilder;
    }

    @Override
    public void close() {
        this.removeDeviceConfiguration();
    }

    public void setTxChain(TransactionChain txChain) {
        this.txChain = (TransactionChain)Preconditions.checkNotNull((Object)txChain);
    }
}

