/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import com.google.common.base.Preconditions;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.Transaction;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.TransactionChainListener;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceNotificationService;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceTopologyAdapter;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfDeviceSalProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceSalProvider.class);
    private final RemoteDeviceId id;
    private final MountInstance mountInstance;
    private final DataBroker dataBroker;
    private volatile NetconfDeviceTopologyAdapter topologyDatastoreAdapter;
    private TransactionChain txChain;
    private final TransactionChainListener transactionChainListener = new TransactionChainListener(){

        public void onTransactionChainFailed(TransactionChain chain, Transaction transaction, Throwable cause) {
            LOG.error("{}: TransactionChain({}) {} FAILED!", new Object[]{NetconfDeviceSalProvider.this.id, chain, transaction.getIdentifier(), cause});
            chain.close();
            NetconfDeviceSalProvider.this.resetTransactionChainForAdapaters();
            throw new IllegalStateException(NetconfDeviceSalProvider.this.id + "  TransactionChain(" + chain + ") not committed correctly", cause);
        }

        public void onTransactionChainSuccessful(TransactionChain chain) {
            LOG.trace("{}: TransactionChain({}) SUCCESSFUL", (Object)NetconfDeviceSalProvider.this.id, (Object)chain);
        }
    };

    public NetconfDeviceSalProvider(RemoteDeviceId deviceId, DOMMountPointService mountService) {
        this(deviceId, mountService, null);
    }

    public NetconfDeviceSalProvider(RemoteDeviceId deviceId, DOMMountPointService mountService, DataBroker dataBroker) {
        this.id = deviceId;
        this.mountInstance = new MountInstance(mountService, this.id);
        this.dataBroker = dataBroker;
        if (dataBroker != null) {
            this.txChain = ((DataBroker)Preconditions.checkNotNull((Object)dataBroker)).createTransactionChain(this.transactionChainListener);
            this.topologyDatastoreAdapter = new NetconfDeviceTopologyAdapter(this.id, this.txChain);
        }
    }

    public MountInstance getMountInstance() {
        Preconditions.checkState((this.mountInstance != null ? 1 : 0) != 0, (String)"%s: Mount instance was not initialized by sal. Cannot get mount instance", (Object)this.id);
        return this.mountInstance;
    }

    public NetconfDeviceTopologyAdapter getTopologyDatastoreAdapter() {
        Preconditions.checkState((this.topologyDatastoreAdapter != null ? 1 : 0) != 0, (String)"%s: Sal provider %s was not initialized by sal. Cannot get topology datastore adapter", (Object)this.id);
        return this.topologyDatastoreAdapter;
    }

    private void resetTransactionChainForAdapaters() {
        this.txChain = ((DataBroker)Preconditions.checkNotNull((Object)this.dataBroker)).createTransactionChain(this.transactionChainListener);
        this.topologyDatastoreAdapter.setTxChain(this.txChain);
        LOG.trace("{}: Resetting TransactionChain {}", (Object)this.id, (Object)this.txChain);
    }

    @Override
    public void close() {
        this.mountInstance.close();
        if (this.topologyDatastoreAdapter != null) {
            this.topologyDatastoreAdapter.close();
        }
        this.topologyDatastoreAdapter = null;
        if (this.txChain != null) {
            this.txChain.close();
        }
    }

    public static class MountInstance
    implements AutoCloseable {
        private final DOMMountPointService mountService;
        private final RemoteDeviceId id;
        private NetconfDeviceNotificationService notificationService;
        private ObjectRegistration<DOMMountPoint> topologyRegistration;

        MountInstance(DOMMountPointService mountService, RemoteDeviceId id) {
            this.mountService = (DOMMountPointService)Preconditions.checkNotNull((Object)mountService);
            this.id = (RemoteDeviceId)Preconditions.checkNotNull((Object)id);
        }

        public void onTopologyDeviceConnected(SchemaContext initialCtx, DOMDataBroker broker, DOMRpcService rpc, NetconfDeviceNotificationService newNotificationService) {
            this.onTopologyDeviceConnected(initialCtx, broker, rpc, newNotificationService, null);
        }

        public synchronized void onTopologyDeviceConnected(SchemaContext initialCtx, DOMDataBroker broker, DOMRpcService rpc, NetconfDeviceNotificationService newNotificationService, DOMActionService deviceAction) {
            Preconditions.checkNotNull((Object)this.mountService, (Object)"Closed");
            Preconditions.checkState((this.topologyRegistration == null ? 1 : 0) != 0, (Object)"Already initialized");
            DOMMountPointService.DOMMountPointBuilder mountBuilder = this.mountService.createMountPoint(this.id.getTopologyPath());
            mountBuilder.addInitialSchemaContext(initialCtx);
            mountBuilder.addService(DOMDataBroker.class, (DOMService)broker);
            mountBuilder.addService(DOMRpcService.class, (DOMService)rpc);
            mountBuilder.addService(DOMNotificationService.class, (DOMService)newNotificationService);
            if (deviceAction != null) {
                mountBuilder.addService(DOMActionService.class, (DOMService)deviceAction);
            }
            this.notificationService = newNotificationService;
            this.topologyRegistration = mountBuilder.register();
            LOG.debug("{}: TOPOLOGY Mountpoint exposed into MD-SAL {}", (Object)this.id, this.topologyRegistration);
        }

        public synchronized void onTopologyDeviceDisconnected() {
            if (this.topologyRegistration == null) {
                LOG.trace("{}: Not removing TOPOLOGY mountpoint from MD-SAL, mountpoint was not registered yet", (Object)this.id);
                return;
            }
            try {
                this.topologyRegistration.close();
            }
            catch (Exception e) {
                LOG.warn("Unable to unregister mount instance for {}. Ignoring exception", (Object)this.id.getTopologyPath(), (Object)e);
            }
            finally {
                LOG.debug("{}: TOPOLOGY Mountpoint removed from MD-SAL {}", (Object)this.id, this.topologyRegistration);
                this.topologyRegistration = null;
            }
        }

        @Override
        public synchronized void close() {
            this.onTopologyDeviceDisconnected();
        }

        public synchronized void publish(DOMNotification domNotification) {
            Preconditions.checkNotNull((Object)this.notificationService, (String)"Device not set up yet, cannot handle notification {}", (Object)domNotification);
            this.notificationService.publishNotification(domNotification);
        }
    }
}

