/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCapabilities;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceDataBroker;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceNotificationService;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceSalProvider;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfDeviceSalFacade
implements AutoCloseable,
RemoteDeviceHandler<NetconfSessionPreferences> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceSalFacade.class);
    private final RemoteDeviceId id;
    private final NetconfDeviceSalProvider salProvider;
    private final List<AutoCloseable> salRegistrations = new ArrayList<AutoCloseable>();

    public NetconfDeviceSalFacade(RemoteDeviceId id, DOMMountPointService mountPointService, DataBroker dataBroker) {
        this.id = id;
        this.salProvider = new NetconfDeviceSalProvider(id, mountPointService, dataBroker);
    }

    @VisibleForTesting
    NetconfDeviceSalFacade(RemoteDeviceId id, NetconfDeviceSalProvider salProvider) {
        this.id = id;
        this.salProvider = salProvider;
    }

    @Override
    public synchronized void onNotification(DOMNotification domNotification) {
        this.salProvider.getMountInstance().publish(domNotification);
    }

    @Override
    public synchronized void onDeviceConnected(SchemaContext schemaContext, NetconfSessionPreferences netconfSessionPreferences, DOMRpcService deviceRpc, DOMActionService deviceAction) {
        NetconfDeviceDataBroker domBroker = new NetconfDeviceDataBroker(this.id, schemaContext, deviceRpc, netconfSessionPreferences);
        NetconfDeviceNotificationService notificationService = new NetconfDeviceNotificationService();
        this.salProvider.getMountInstance().onTopologyDeviceConnected(schemaContext, domBroker, deviceRpc, notificationService, deviceAction);
        this.salProvider.getTopologyDatastoreAdapter().updateDeviceData(true, netconfSessionPreferences.getNetconfDeviceCapabilities());
    }

    @Override
    public synchronized void onDeviceDisconnected() {
        this.salProvider.getTopologyDatastoreAdapter().updateDeviceData(false, new NetconfDeviceCapabilities());
        this.salProvider.getMountInstance().onTopologyDeviceDisconnected();
    }

    @Override
    public synchronized void onDeviceFailed(Throwable throwable) {
        this.salProvider.getTopologyDatastoreAdapter().setDeviceAsFailed(throwable);
        this.salProvider.getMountInstance().onTopologyDeviceDisconnected();
    }

    @Override
    public synchronized void close() {
        for (AutoCloseable reg : Lists.reverse(this.salRegistrations)) {
            this.closeGracefully(reg);
        }
        this.closeGracefully(this.salProvider);
    }

    private void closeGracefully(AutoCloseable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception e) {
                LOG.warn("{}: Ignoring exception while closing {}", new Object[]{this.id, resource, e});
            }
        }
    }
}

