/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import com.google.common.collect.Collections2;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.sal.connect.api.MessageTransformer;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceCommunicator;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.NoOpListenerRegistration;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class NetconfDeviceRpc
implements DOMRpcService {
    private final RemoteDeviceCommunicator<NetconfMessage> communicator;
    private final MessageTransformer<NetconfMessage> transformer;
    private final SchemaContext schemaContext;

    public NetconfDeviceRpc(SchemaContext schemaContext, RemoteDeviceCommunicator<NetconfMessage> communicator, MessageTransformer<NetconfMessage> transformer) {
        this.communicator = communicator;
        this.transformer = transformer;
        this.schemaContext = Objects.requireNonNull(schemaContext);
    }

    public FluentFuture<DOMRpcResult> invokeRpc(final SchemaPath type, NormalizedNode<?, ?> input) {
        FluentFuture<RpcResult<NetconfMessage>> delegateFuture = this.communicator.sendRequest(this.transformer.toRpcRequest(type, input), type.getLastComponent());
        final SettableFuture ret = SettableFuture.create();
        delegateFuture.addCallback((FutureCallback)new FutureCallback<RpcResult<NetconfMessage>>(){

            public void onSuccess(RpcResult<NetconfMessage> result) {
                ret.set(result.isSuccessful() ? NetconfDeviceRpc.this.transformer.toRpcResult(result.getResult(), type) : new DefaultDOMRpcResult(result.getErrors()));
            }

            public void onFailure(Throwable cause) {
                ret.setException((Throwable)new DOMRpcImplementationNotAvailableException(cause, "Unable to invoke rpc %s", new Object[]{type}));
            }
        }, MoreExecutors.directExecutor());
        return ret;
    }

    @Nonnull
    public <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(@Nonnull T listener) {
        listener.onRpcAvailable(Collections2.transform((Collection)this.schemaContext.getOperations(), input -> DOMRpcIdentifier.create((SchemaPath)input.getPath())));
        return NoOpListenerRegistration.of(listener);
    }
}

