/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.sal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfDeviceNotificationService
implements DOMNotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceNotificationService.class);
    private final Multimap<SchemaPath, DOMNotificationListener> listeners = HashMultimap.create();

    public synchronized void publishNotification(DOMNotification notification) {
        for (DOMNotificationListener domNotificationListener : this.listeners.get((Object)notification.getType())) {
            try {
                domNotificationListener.onNotification(notification);
            }
            catch (Exception e) {
                LOG.warn("Listener {} threw an uncaught exception during processing notification {}", new Object[]{domNotificationListener, notification, e});
            }
        }
    }

    public synchronized <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(final @Nonnull T listener, final @Nonnull Collection<SchemaPath> types) {
        for (SchemaPath type : types) {
            this.listeners.put((Object)type, listener);
        }
        return new AbstractListenerRegistration<T>(listener){

            protected void removeRegistration() {
                for (SchemaPath type : types) {
                    NetconfDeviceNotificationService.this.listeners.remove((Object)type, (Object)listener);
                }
            }
        };
    }

    public synchronized <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(@Nonnull T listener, SchemaPath ... types) {
        return this.registerNotificationListener(listener, Lists.newArrayList((Object[])types));
    }
}

