/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.listener;

import javax.annotation.Nonnull;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;

public class UserPreferences {
    private final NetconfSessionPreferences sessionPreferences;
    private final boolean overrideModuleCapabilities;
    private final boolean overrideNonModuleCapabilities;

    public UserPreferences(@Nonnull NetconfSessionPreferences sessionPreferences, boolean overrideModuleCapabilities, boolean overrideNonModuleCapabilities) {
        if (overrideModuleCapabilities && (sessionPreferences.getModuleBasedCaps() == null || sessionPreferences.getModuleBasedCaps().isEmpty())) {
            throw new IllegalStateException("Override module based capabilities flag set true but module based capabilities list is empty.");
        }
        if (overrideNonModuleCapabilities && (sessionPreferences.getNonModuleCaps() == null || sessionPreferences.getNonModuleCaps().isEmpty())) {
            throw new IllegalStateException("Override non-module based capabilities set true but non-module based capabilities list is empty.");
        }
        this.sessionPreferences = sessionPreferences;
        this.overrideModuleCapabilities = overrideModuleCapabilities;
        this.overrideNonModuleCapabilities = overrideNonModuleCapabilities;
    }

    public NetconfSessionPreferences getSessionPreferences() {
        return this.sessionPreferences;
    }

    public boolean moduleBasedCapsOverrided() {
        return this.overrideModuleCapabilities;
    }

    public boolean nonModuleBasedCapsOverrided() {
        return this.overrideNonModuleCapabilities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UserPreferences{");
        sb.append("sessionPreferences=").append(this.sessionPreferences);
        sb.append(", overrideModuleCapabilities=").append(this.overrideModuleCapabilities);
        sb.append(", overrideNonModuleCapabilities=").append(this.overrideNonModuleCapabilities);
        sb.append('}');
        return sb.toString();
    }
}

