/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.listener;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.util.concurrent.Future;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.FailedNetconfMessage;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfTerminationReason;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfReconnectingClientConfiguration;
import org.opendaylight.netconf.sal.connect.api.RemoteDevice;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCapabilities;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.listener.UncancellableFuture;
import org.opendaylight.netconf.sal.connect.netconf.listener.UserPreferences;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NetconfDeviceCommunicator
implements NetconfClientSessionListener,
RemoteDeviceCommunicator<NetconfMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceCommunicator.class);
    protected final RemoteDevice<NetconfSessionPreferences, NetconfMessage, NetconfDeviceCommunicator> remoteDevice;
    private final Optional<UserPreferences> overrideNetconfCapabilities;
    protected final RemoteDeviceId id;
    private final Lock sessionLock = new ReentrantLock();
    private final Semaphore semaphore;
    private final int concurentRpcMsgs;
    private final Queue<Request> requests = new ArrayDeque<Request>();
    private NetconfClientSession currentSession;
    private final SettableFuture<NetconfDeviceCapabilities> firstConnectionFuture;
    private Future<?> initFuture;
    private static final AtomicIntegerFieldUpdater<NetconfDeviceCommunicator> CLOSING_UPDATER = AtomicIntegerFieldUpdater.newUpdater(NetconfDeviceCommunicator.class, "closing");
    private volatile int closing = 0;

    public boolean isSessionClosing() {
        return this.closing != 0;
    }

    public NetconfDeviceCommunicator(RemoteDeviceId id, RemoteDevice<NetconfSessionPreferences, NetconfMessage, NetconfDeviceCommunicator> remoteDevice, UserPreferences netconfSessionPreferences, int rpcMessageLimit) {
        this(id, remoteDevice, (Optional<UserPreferences>)Optional.of((Object)netconfSessionPreferences), rpcMessageLimit);
    }

    public NetconfDeviceCommunicator(RemoteDeviceId id, RemoteDevice<NetconfSessionPreferences, NetconfMessage, NetconfDeviceCommunicator> remoteDevice, int rpcMessageLimit) {
        this(id, remoteDevice, (Optional<UserPreferences>)Optional.absent(), rpcMessageLimit);
    }

    private NetconfDeviceCommunicator(RemoteDeviceId id, RemoteDevice<NetconfSessionPreferences, NetconfMessage, NetconfDeviceCommunicator> remoteDevice, Optional<UserPreferences> overrideNetconfCapabilities, int rpcMessageLimit) {
        this.concurentRpcMsgs = rpcMessageLimit;
        this.id = id;
        this.remoteDevice = remoteDevice;
        this.overrideNetconfCapabilities = overrideNetconfCapabilities;
        this.firstConnectionFuture = SettableFuture.create();
        this.semaphore = rpcMessageLimit > 0 ? new Semaphore(rpcMessageLimit) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionUp(NetconfClientSession session) {
        this.sessionLock.lock();
        try {
            LOG.debug("{}: Session established", (Object)this.id);
            this.currentSession = session;
            NetconfSessionPreferences netconfSessionPreferences = NetconfSessionPreferences.fromNetconfSession(session);
            LOG.trace("{}: Session advertised capabilities: {}", (Object)this.id, (Object)netconfSessionPreferences);
            if (this.overrideNetconfCapabilities.isPresent()) {
                NetconfSessionPreferences sessionPreferences = ((UserPreferences)this.overrideNetconfCapabilities.get()).getSessionPreferences();
                netconfSessionPreferences = ((UserPreferences)this.overrideNetconfCapabilities.get()).moduleBasedCapsOverrided() ? netconfSessionPreferences.replaceModuleCaps(sessionPreferences) : netconfSessionPreferences.addModuleCaps(sessionPreferences);
                netconfSessionPreferences = ((UserPreferences)this.overrideNetconfCapabilities.get()).nonModuleBasedCapsOverrided() ? netconfSessionPreferences.replaceNonModuleCaps(sessionPreferences) : netconfSessionPreferences.addNonModuleCaps(sessionPreferences);
                LOG.debug("{}: Session capabilities overridden, capabilities that will be used: {}", (Object)this.id, (Object)netconfSessionPreferences);
            }
            this.remoteDevice.onRemoteSessionUp(netconfSessionPreferences, this);
            if (!this.firstConnectionFuture.isDone()) {
                this.firstConnectionFuture.set((Object)netconfSessionPreferences.getNetconfDeviceCapabilities());
            }
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    public ListenableFuture<NetconfDeviceCapabilities> initializeRemoteConnection(NetconfClientDispatcher dispatcher, NetconfClientConfiguration config) {
        this.initFuture = config instanceof NetconfReconnectingClientConfiguration ? dispatcher.createReconnectingClient((NetconfReconnectingClientConfiguration)config) : dispatcher.createClient(config);
        this.initFuture.addListener(future -> {
            if (!future.isSuccess() && !future.isCancelled()) {
                LOG.debug("{}: Connection failed", (Object)this.id, (Object)future.cause());
                this.remoteDevice.onRemoteSessionFailed(future.cause());
                if (this.firstConnectionFuture.isDone()) {
                    this.firstConnectionFuture.setException(future.cause());
                }
            }
        });
        return this.firstConnectionFuture;
    }

    public void disconnect() {
        if (this.currentSession != null && this.startClosing() && this.currentSession.isUp()) {
            this.currentSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDown(String reason) {
        if (!this.isSessionClosing()) {
            LOG.warn("It's curious that no one to close the session but tearDown is called!");
        }
        LOG.debug("Tearing down {}", (Object)reason);
        ArrayList<UncancellableFuture<RpcResult<NetconfMessage>>> futuresToCancel = new ArrayList<UncancellableFuture<RpcResult<NetconfMessage>>>();
        this.sessionLock.lock();
        try {
            if (this.currentSession != null) {
                this.currentSession = null;
                Iterator it = this.requests.iterator();
                while (it.hasNext()) {
                    Request request = (Request)it.next();
                    if (request.future.isUncancellable()) {
                        futuresToCancel.add(request.future);
                        it.remove();
                        continue;
                    }
                    if (!request.future.isCancelled()) continue;
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        finally {
            this.remoteDevice.onRemoteSessionDown();
            this.sessionLock.unlock();
        }
        for (UncancellableFuture uncancellableFuture : futuresToCancel) {
            if (Strings.isNullOrEmpty((String)reason)) {
                uncancellableFuture.set(this.createSessionDownRpcResult());
                continue;
            }
            uncancellableFuture.set(NetconfDeviceCommunicator.createErrorRpcResult(RpcError.ErrorType.TRANSPORT, reason));
        }
        this.closing = 0;
    }

    private RpcResult<NetconfMessage> createSessionDownRpcResult() {
        return NetconfDeviceCommunicator.createErrorRpcResult(RpcError.ErrorType.TRANSPORT, String.format("The netconf session to %1$s is disconnected", this.id.getName()));
    }

    private static RpcResult<NetconfMessage> createErrorRpcResult(RpcError.ErrorType errorType, String message) {
        return RpcResultBuilder.failed().withError(errorType, DocumentedException.ErrorTag.OPERATION_FAILED.getTagValue(), message).build();
    }

    public void onSessionDown(NetconfClientSession session, Exception exception) {
        if (this.startClosing()) {
            LOG.warn("{}: Session went down", (Object)this.id, (Object)exception);
            this.tearDown(null);
        }
    }

    public void onSessionTerminated(NetconfClientSession session, NetconfTerminationReason reason) {
        LOG.warn("{}: Session terminated {}", (Object)this.id, (Object)reason);
        this.tearDown(reason.getErrorMessage());
    }

    @Override
    public void close() {
        if (this.initFuture != null) {
            this.initFuture.cancel(false);
        }
        this.disconnect();
    }

    public void onMessage(NetconfClientSession session, NetconfMessage message) {
        if (NetconfDeviceCommunicator.isNotification(message)) {
            this.processNotification(message);
        } else {
            this.processMessage(message);
        }
    }

    private void processMessage(NetconfMessage message) {
        Request request = null;
        this.sessionLock.lock();
        try {
            request = this.requests.peek();
            if (request != null && request.future.isUncancellable()) {
                request = this.requests.poll();
                if (this.semaphore != null) {
                    this.semaphore.release();
                }
            } else {
                request = null;
                LOG.warn("{}: Ignoring unsolicited message {}", (Object)this.id, (Object)NetconfDeviceCommunicator.msgToS(message));
            }
        }
        finally {
            this.sessionLock.unlock();
        }
        if (request != null) {
            if (FailedNetconfMessage.class.isInstance(message)) {
                request.future.set(NetconfMessageTransformUtil.toRpcResult((FailedNetconfMessage)message));
                return;
            }
            LOG.info("{}: Message received {}", (Object)this.id, (Object)message);
            try {
                NetconfMessageTransformUtil.checkValidReply(request.request, message);
            }
            catch (NetconfDocumentedException e) {
                LOG.warn("{}: Invalid request-reply match,reply message contains different message-id, request: {}, response: {}", new Object[]{this.id, NetconfDeviceCommunicator.msgToS(request.request), NetconfDeviceCommunicator.msgToS(message), e});
                request.future.set((RpcResult<NetconfMessage>)RpcResultBuilder.failed().withRpcError(NetconfMessageTransformUtil.toRpcError(e)).build());
                this.processMessage(message);
                return;
            }
            try {
                NetconfMessageTransformUtil.checkSuccessReply(message);
            }
            catch (NetconfDocumentedException e) {
                LOG.warn("{}: Error reply from remote device, request: {}, response: {}", new Object[]{this.id, NetconfDeviceCommunicator.msgToS(request.request), NetconfDeviceCommunicator.msgToS(message)});
                request.future.set((RpcResult<NetconfMessage>)RpcResultBuilder.failed().withRpcError(NetconfMessageTransformUtil.toRpcError(e)).build());
                return;
            }
            request.future.set((RpcResult<NetconfMessage>)RpcResultBuilder.success((Object)message).build());
        }
    }

    private static String msgToS(NetconfMessage msg) {
        return XmlUtil.toString((Document)msg.getDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FluentFuture<RpcResult<NetconfMessage>> sendRequest(NetconfMessage message, QName rpc) {
        this.sessionLock.lock();
        try {
            if (this.semaphore != null && !this.semaphore.tryAcquire()) {
                LOG.warn("Limit of concurrent rpc messages was reached (limit: {}). Rpc reply message is needed. Discarding request of Netconf device with id {}", (Object)this.concurentRpcMsgs, (Object)this.id.getName());
                FluentFuture fluentFuture = FluentFutures.immediateFailedFluentFuture((Throwable)new NetconfDocumentedException("Limit of rpc messages was reached (Limit :" + this.concurentRpcMsgs + ") waiting for emptying the queue of Netconf device with id" + this.id.getName()));
                return fluentFuture;
            }
            FluentFuture<RpcResult<NetconfMessage>> fluentFuture = this.sendRequestWithLock(message, rpc);
            return fluentFuture;
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    private FluentFuture<RpcResult<NetconfMessage>> sendRequestWithLock(NetconfMessage message, QName rpc) {
        LOG.info("{}: Sending message {}", (Object)this.id, (Object)NetconfDeviceCommunicator.msgToS(message));
        if (this.currentSession == null) {
            LOG.warn("{}: Session is disconnected, failing RPC request {}", (Object)this.id, (Object)message);
            return FluentFutures.immediateFluentFuture(this.createSessionDownRpcResult());
        }
        Request req = new Request(new UncancellableFuture(true), message);
        this.requests.add(req);
        this.currentSession.sendMessage(req.request).addListener(future -> {
            if (!future.isSuccess()) {
                LOG.warn("{}: Failed to send request {}", new Object[]{this.id, XmlUtil.toString((Document)req.request.getDocument()), future.cause()});
                if (future.cause() != null) {
                    req.future.set(NetconfDeviceCommunicator.createErrorRpcResult(RpcError.ErrorType.TRANSPORT, future.cause().getLocalizedMessage()));
                } else {
                    req.future.set(this.createSessionDownRpcResult());
                }
                req.future.setException(future.cause());
            } else {
                LOG.trace("Finished sending request {}", (Object)req.request);
            }
        });
        return req.future;
    }

    private void processNotification(NetconfMessage notification) {
        LOG.info("{}: Notification received: {}", (Object)this.id, (Object)notification);
        try {
            this.remoteDevice.onNotification(notification);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            LOG.warn("Unable to parse received notification {}. {}", (Object)notification, (Object)ex.getMessage());
        }
    }

    private static boolean isNotification(NetconfMessage message) {
        if (message.getDocument() == null) {
            return false;
        }
        XmlElement xmle = XmlElement.fromDomDocument((Document)message.getDocument());
        return "notification".equals(xmle.getName());
    }

    private boolean startClosing() {
        return CLOSING_UPDATER.compareAndSet(this, 0, 1);
    }

    private static final class Request {
        final UncancellableFuture<RpcResult<NetconfMessage>> future;
        final NetconfMessage request;

        private Request(UncancellableFuture<RpcResult<NetconfMessage>> future, NetconfMessage request) {
            this.future = future;
            this.request = request;
        }
    }
}

