/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.listener;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.unavailable.capabilities.UnavailableCapability;
import org.opendaylight.yangtools.yang.common.QName;

public final class NetconfDeviceCapabilities {
    private final Map<QName, UnavailableCapability.FailureReason> unresolvedCapabilites = new HashMap<QName, UnavailableCapability.FailureReason>();
    private final Set<AvailableCapability> resolvedCapabilities = new HashSet<AvailableCapability>();
    private final Set<AvailableCapability> nonModuleBasedCapabilities = new HashSet<AvailableCapability>();

    public void addUnresolvedCapability(QName source, UnavailableCapability.FailureReason reason) {
        this.unresolvedCapabilites.put(source, reason);
    }

    public void addUnresolvedCapabilities(Collection<QName> capabilities, UnavailableCapability.FailureReason reason) {
        for (QName s : capabilities) {
            this.unresolvedCapabilites.put(s, reason);
        }
    }

    public void addCapabilities(Collection<AvailableCapability> availableSchemas) {
        this.resolvedCapabilities.addAll(availableSchemas);
    }

    public void addNonModuleBasedCapabilities(Collection<AvailableCapability> nonModuleCapabilities) {
        this.nonModuleBasedCapabilities.addAll(nonModuleCapabilities);
    }

    public Set<AvailableCapability> getNonModuleBasedCapabilities() {
        return this.nonModuleBasedCapabilities;
    }

    public Map<QName, UnavailableCapability.FailureReason> getUnresolvedCapabilites() {
        return this.unresolvedCapabilites;
    }

    public Set<AvailableCapability> getResolvedCapabilities() {
        return this.resolvedCapabilities;
    }
}

