/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.sal.connect.api.MessageTransformer;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

final class NotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationHandler.class);
    private final RemoteDeviceHandler<?> salFacade;
    private final List<NetconfMessage> queue = new LinkedList<NetconfMessage>();
    private final RemoteDeviceId id;
    private boolean passNotifications = false;
    private NotificationFilter filter;
    private MessageTransformer<NetconfMessage> messageTransformer;

    NotificationHandler(RemoteDeviceHandler<?> salFacade, RemoteDeviceId id) {
        this.salFacade = (RemoteDeviceHandler)Preconditions.checkNotNull(salFacade);
        this.id = (RemoteDeviceId)Preconditions.checkNotNull((Object)id);
    }

    synchronized void handleNotification(NetconfMessage notification) {
        if (this.passNotifications) {
            this.passNotification(this.transformNotification(notification));
        } else {
            this.queueNotification(notification);
        }
    }

    synchronized void onRemoteSchemaUp(MessageTransformer<NetconfMessage> transformer) {
        this.messageTransformer = (MessageTransformer)Preconditions.checkNotNull(transformer);
        this.passNotifications = true;
        for (NetconfMessage cachedNotification : this.queue) {
            try {
                this.passNotification(this.transformNotification(cachedNotification));
            }
            catch (IllegalArgumentException | NullPointerException ex) {
                LOG.warn("Unable to parse cached notifications while initializing sal.", (Throwable)ex);
            }
        }
        this.queue.clear();
    }

    private DOMNotification transformNotification(NetconfMessage cachedNotification) {
        DOMNotification parsedNotification = this.messageTransformer.toNotification(cachedNotification);
        Preconditions.checkNotNull((Object)parsedNotification, (String)"%s: Unable to parse received notification: %s", (Object)this.id, (Object)cachedNotification);
        return parsedNotification;
    }

    private void queueNotification(NetconfMessage notification) {
        Preconditions.checkState((!this.passNotifications ? 1 : 0) != 0);
        LOG.debug("{}: Caching notification {}, remote schema not yet fully built", (Object)this.id, (Object)notification);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: Caching notification {}", (Object)this.id, (Object)XmlUtil.toString((Document)notification.getDocument()));
        }
        this.queue.add(notification);
    }

    private synchronized void passNotification(DOMNotification parsedNotification) {
        LOG.debug("{}: Forwarding notification {}", (Object)this.id, (Object)parsedNotification);
        if (this.filter == null || this.filter.filterNotification(parsedNotification).isPresent()) {
            this.salFacade.onNotification(parsedNotification);
        }
    }

    synchronized void addNotificationFilter(NotificationFilter newFilter) {
        this.filter = newFilter;
    }

    synchronized void onRemoteSchemaDown() {
        this.queue.clear();
        this.passNotifications = false;
        this.messageTransformer = null;
    }

    static interface NotificationFilter {
        public Optional<DOMNotification> filterNotification(DOMNotification var1);
    }
}

