/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.NeighborOrigin;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.Ipv6;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6.NeighborKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

public interface Neighbor
extends ChildOf<Ipv6>,
Augmentable<Neighbor>,
Identifiable<NeighborKey> {
    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("neighbor");

    public @Nullable Ipv6AddressNoZone getIp();

    public @Nullable PhysAddress getLinkLayerAddress();

    public @Nullable NeighborOrigin getOrigin();

    public @Nullable Boolean isIsRouter();

    public @Nullable State getState();

    public NeighborKey key();

    public static enum State implements Enumeration
    {
        Incomplete(0, "incomplete"),
        Reachable(1, "reachable"),
        Stale(2, "stale"),
        Delay(3, "delay"),
        Probe(4, "probe");

        private static final Map<String, State> NAME_MAP;
        private static final Map<Integer, State> VALUE_MAP;
        private final String name;
        private final int value;

        private State(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<State> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static State forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (State enumItem : State.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

