/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6.Neighbor;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6.NeighborKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NeighborBuilder
implements Builder<Neighbor> {
    private Ipv6AddressNoZone _ip;
    private PhysAddress _linkLayerAddress;
    private NeighborKey key;
    Map<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>> augmentation = Collections.emptyMap();

    public NeighborBuilder() {
    }

    public NeighborBuilder(Neighbor base) {
        Map aug;
        this.key = base.key();
        this._ip = base.getIp();
        this._linkLayerAddress = base.getLinkLayerAddress();
        if (base instanceof NeighborImpl) {
            NeighborImpl impl = (NeighborImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>>(aug);
        }
    }

    public NeighborKey key() {
        return this.key;
    }

    public Ipv6AddressNoZone getIp() {
        return this._ip;
    }

    public PhysAddress getLinkLayerAddress() {
        return this._linkLayerAddress;
    }

    public <E$$ extends Augmentation<Neighbor>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NeighborBuilder withKey(NeighborKey key) {
        this.key = key;
        return this;
    }

    public NeighborBuilder setIp(Ipv6AddressNoZone value) {
        this._ip = value;
        return this;
    }

    public NeighborBuilder setLinkLayerAddress(PhysAddress value) {
        this._linkLayerAddress = value;
        return this;
    }

    public NeighborBuilder addAugmentation(Class<? extends Augmentation<Neighbor>> augmentationType, Augmentation<Neighbor> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NeighborBuilder removeAugmentation(Class<? extends Augmentation<Neighbor>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Neighbor build() {
        return new NeighborImpl(this);
    }

    private static final class NeighborImpl
    implements Neighbor {
        private final Ipv6AddressNoZone _ip;
        private final PhysAddress _linkLayerAddress;
        private final NeighborKey key;
        private Map<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NeighborImpl(NeighborBuilder base) {
            this.key = base.key() != null ? base.key() : new NeighborKey(base.getIp());
            this._ip = this.key.getIp();
            this._linkLayerAddress = base.getLinkLayerAddress();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Neighbor> getImplementedInterface() {
            return Neighbor.class;
        }

        @Override
        public NeighborKey key() {
            return this.key;
        }

        @Override
        public Ipv6AddressNoZone getIp() {
            return this._ip;
        }

        @Override
        public PhysAddress getLinkLayerAddress() {
            return this._linkLayerAddress;
        }

        public <E$$ extends Augmentation<Neighbor>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            result = 31 * result + Objects.hashCode(this._linkLayerAddress);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Neighbor.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Neighbor other = (Neighbor)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals(this._linkLayerAddress, other.getLinkLayerAddress())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NeighborImpl otherImpl = (NeighborImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Neighbor");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ip", (Object)this._ip);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_linkLayerAddress", (Object)this._linkLayerAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

