/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum IpAddressOrigin implements Enumeration
{
    Other(0, "other"),
    Static(1, "static"),
    Dhcp(2, "dhcp"),
    LinkLayer(3, "link-layer"),
    Random(4, "random");

    private static final Map<String, IpAddressOrigin> NAME_MAP;
    private static final Map<Integer, IpAddressOrigin> VALUE_MAP;
    private final String name;
    private final int value;

    private IpAddressOrigin(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<IpAddressOrigin> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static IpAddressOrigin forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (IpAddressOrigin enumItem : IpAddressOrigin.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

