/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.AbstractDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;

final class RecursiveReplaceCandidateNode
extends AbstractDataTreeCandidateNode {
    private final NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> oldData;

    RecursiveReplaceCandidateNode(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> oldData, NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> newData) {
        super(newData);
        this.oldData = Objects.requireNonNull(oldData);
    }

    @Override
    public ModificationType getModificationType() {
        return ModificationType.WRITE;
    }

    @Override
    public Optional<NormalizedNode<?, ?>> getDataAfter() {
        return this.dataOptional();
    }

    @Override
    public Optional<NormalizedNode<?, ?>> getDataBefore() {
        return Optional.of(this.oldData);
    }

    @Override
    public DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
        return DataTreeCandidateNodes.containerDelta(this.oldData, this.data(), identifier);
    }

    @Override
    public Collection<DataTreeCandidateNode> getChildNodes() {
        return DataTreeCandidateNodes.containerDelta(this.oldData, this.data());
    }
}

